/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.button.GuiButtonDisableableImage;
import mekanism.client.gui.button.GuiSideDataButton;
import mekanism.client.gui.element.tab.GuiConfigTypeTab;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketConfigurationUpdate;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiSideConfiguration
extends GuiMekanismTile<TileEntityContainerBlock> {
    private Map<Integer, GuiPos> slotPosMap = new HashMap<Integer, GuiPos>();
    private ISideConfiguration configurable;
    private TransmissionType currentType;
    private List<GuiConfigTypeTab> configTabs = new ArrayList<GuiConfigTypeTab>();
    private List<GuiSideDataButton> sideDataButtons = new ArrayList<GuiSideDataButton>();
    private GuiButton backButton;
    private GuiButton autoEjectButton;
    private int buttonID = 0;

    public GuiSideConfiguration(EntityPlayer player, ISideConfiguration tile) {
        super((TileEntityContainerBlock)((Object)tile), new ContainerNull(player, (TileEntityContainerBlock)((Object)tile)));
        this.field_147000_g = 95;
        this.configurable = tile;
        ResourceLocation resource = this.getGuiLocation();
        for (TransmissionType type : this.configurable.getConfig().getTransmissions()) {
            GuiConfigTypeTab tab = new GuiConfigTypeTab(this, type, resource);
            this.addGuiElement(tab);
            this.configTabs.add(tab);
        }
        this.currentType = this.getTopTransmission();
        this.updateTabs();
        this.slotPosMap.put(0, new GuiPos(81, 64));
        this.slotPosMap.put(1, new GuiPos(81, 34));
        this.slotPosMap.put(2, new GuiPos(81, 49));
        this.slotPosMap.put(3, new GuiPos(66, 64));
        this.slotPosMap.put(4, new GuiPos(66, 49));
        this.slotPosMap.put(5, new GuiPos(96, 49));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.backButton = new GuiButtonDisableableImage(this.buttonID++, this.field_147003_i + 6, this.field_147009_r + 6, 14, 14, 204, 14, -14, this.getGuiLocation());
        this.field_146292_n.add(this.backButton);
        this.autoEjectButton = new GuiButtonDisableableImage(this.buttonID++, this.field_147003_i + 156, this.field_147009_r + 6, 14, 14, 190, 14, -14, this.getGuiLocation());
        this.field_146292_n.add(this.autoEjectButton);
        for (int i = 0; i < this.slotPosMap.size(); ++i) {
            GuiPos guiPos = this.slotPosMap.get(i);
            EnumFacing facing = EnumFacing.func_82600_a((int)i);
            GuiSideDataButton button = new GuiSideDataButton(this.buttonID++, this.field_147003_i + guiPos.xPos, this.field_147009_r + guiPos.yPos, this.getGuiLocation(), i, () -> this.configurable.getConfig().getOutput(this.currentType, facing), () -> this.configurable.getConfig().getOutput((TransmissionType)this.currentType, (EnumFacing)facing).color);
            this.field_146292_n.add(button);
            this.sideDataButtons.add(button);
        }
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        TileEntity tile = (TileEntity)this.configurable;
        if (guibutton.field_146127_k == this.backButton.field_146127_k) {
            int guiId = Mekanism.proxy.getGuiId(tile.func_145838_q(), tile.func_145832_p());
            Mekanism.packetHandler.sendToServer(new PacketSimpleGui.SimpleGuiMessage(Coord4D.get(tile), 0, guiId));
        } else if (guibutton.field_146127_k == this.autoEjectButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.EJECT, Coord4D.get(tile), 0, 0, this.currentType));
        } else {
            for (GuiSideDataButton button : this.sideDataButtons) {
                if (guibutton.field_146127_k != button.field_146127_k) continue;
                Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.SIDE_DATA, Coord4D.get(tile), Keyboard.isKeyDown((int)42) ? 2 : 0, button.getSlotPosMapIndex(), this.currentType));
                break;
            }
        }
    }

    public TransmissionType getTopTransmission() {
        return this.configurable.getConfig().getTransmissions().get(0);
    }

    public void setCurrentType(TransmissionType type) {
        this.currentType = type;
    }

    public void updateTabs() {
        int rendered = 0;
        for (GuiConfigTypeTab tab : this.configTabs) {
            tab.setVisible(this.currentType != tab.getTransmissionType());
            if (tab.isVisible()) {
                tab.setLeft(rendered >= 0 && rendered <= 2);
                tab.setY(2 + rendered % 3 * 28);
            }
            ++rendered;
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        String title = this.currentType.localize() + " " + LangUtils.localize("gui.config");
        this.field_146289_q.func_78276_b(title, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(title) / 2, 5, 0x404040);
        if (this.configurable.getConfig().canEject(this.currentType)) {
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.eject") + ": " + (this.configurable.getConfig().isEjecting(this.currentType) ? "On" : "Off"), 53, 17, 52480);
        } else {
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.noEject"), 53, 17, 52480);
        }
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.slots"), 77, 81, 0x787878);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        for (GuiSideDataButton button : this.sideDataButtons) {
            if (!button.func_146115_a()) continue;
            SideData data = button.getSideData();
            if (data == TileComponentConfig.EMPTY) break;
            this.displayTooltip((Object)((Object)data.color) + data.localize() + " (" + data.color.getColoredName() + ")", xAxis, yAxis);
            break;
        }
        if (this.autoEjectButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.autoEject"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    public void func_73876_c() {
        super.func_73876_c();
        TileEntity tile = (TileEntity)this.configurable;
        if (tile == null || this.field_146297_k.field_71441_e.func_175625_s(tile.func_174877_v()) == null) {
            this.field_146297_k.func_147108_a(null);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 1) {
            for (GuiSideDataButton sideDataButton : this.sideDataButtons) {
                if (!sideDataButton.func_146115_a()) continue;
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.SIDE_DATA, Coord4D.get((TileEntity)this.configurable), 1, sideDataButton.getSlotPosMapIndex(), this.currentType));
                break;
            }
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiConfiguration.png");
    }

    public static class GuiPos {
        public final int xPos;
        public final int yPos;

        public GuiPos(int x, int y) {
            this.xPos = x;
            this.yPos = y;
        }
    }
}

