/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.item;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class ItemLayerWrapper
implements IBakedModel {
    private final IBakedModel internal;
    private ItemCameraTransforms.TransformType transform = ItemCameraTransforms.TransformType.NONE;
    public static Map<ItemCameraTransforms.TransformType, TRSRTransformation> transforms = ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)ItemLayerWrapper.get(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)ItemLayerWrapper.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)ItemLayerWrapper.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)ItemLayerWrapper.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)ItemLayerWrapper.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)ItemLayerWrapper.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f)).put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)ItemLayerWrapper.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)ItemLayerWrapper.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f)).put((Object)ItemCameraTransforms.TransformType.NONE, (Object)ItemLayerWrapper.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)).build();

    public ItemLayerWrapper(IBakedModel internal) {
        this.internal = internal;
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return this.internal.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.internal.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.internal.func_177556_c();
    }

    public IBakedModel getInternal() {
        return this.internal;
    }

    public boolean func_188618_c() {
        return true;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.internal.func_177554_e();
    }

    @Nonnull
    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return this.internal.func_177552_f();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType type) {
        this.transform = type;
        return Pair.of((Object)this, (Object)transforms.get(type).getMatrix());
    }

    @Nonnull
    public ItemCameraTransforms.TransformType getTransform() {
        return this.transform;
    }

    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null);
    }
}

