/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.Optional;
import javax.annotation.Nonnull;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.api.multipart.MultipartHelper;
import mcmultipart.api.slot.IPartSlot;
import mekanism.common.Mekanism;
import mekanism.common.integration.multipart.MultipartMekanism;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

public abstract class ItemBlockMultipartAble
extends ItemBlock {
    public ItemBlockMultipartAble(Block block) {
        super(block);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_190926_b()) {
            return EnumActionResult.FAIL;
        }
        if (Mekanism.hooks.MCMPLoaded) {
            if (!block.func_176200_f((IBlockAccess)worldIn, pos) && !this.hasFreeMultiPartSpot(itemstack, worldIn, pos, iblockstate, facing)) {
                pos = pos.func_177972_a(facing);
                iblockstate = worldIn.func_180495_p(pos);
            }
        } else if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (player.func_175151_a(pos, facing, itemstack) && this.mayPlace(itemstack, worldIn, pos, iblockstate, hand, facing)) {
            int i = this.func_77647_b(itemstack.func_77960_j());
            IBlockState iblockstate1 = this.field_150939_a.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player, hand);
            boolean flag = Mekanism.hooks.MCMPLoaded ? MultipartMekanism.placeMultipartBlock(this.field_150939_a, itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ, iblockstate1) : this.placeBlockAt(itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ, iblockstate1);
            if (flag) {
                iblockstate1 = worldIn.func_180495_p(pos);
                SoundType soundtype = iblockstate1.func_177230_c().getSoundType(iblockstate1, worldIn, pos, (Entity)player);
                worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                itemstack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    private boolean mayPlace(ItemStack itemstack, World worldIn, BlockPos pos, IBlockState state, EnumHand hand, EnumFacing facing) {
        if (!Mekanism.hooks.MCMPLoaded) {
            return worldIn.func_190527_a(this.field_150939_a, pos, false, facing, null);
        }
        return worldIn.func_190527_a(this.field_150939_a, pos, false, facing, null) || this.hasFreeMultiPartSpot(itemstack, worldIn, pos, state, facing);
    }

    private boolean hasFreeMultiPartSpot(ItemStack itemstack, World worldIn, BlockPos pos, IBlockState state, EnumFacing facing) {
        Optional container;
        if (!Mekanism.hooks.MCMPLoaded || !(container = MultipartHelper.getContainer((IBlockAccess)worldIn, (BlockPos)pos)).isPresent()) {
            return false;
        }
        IMultipart multipart = this.getMultiPart();
        IPartSlot slot = multipart.getSlotForPlacement(worldIn, pos, state, facing, 0.0f, 0.0f, 0.0f, null);
        return ((IMultipartContainer)container.get()).canAddPart(slot, this.field_150939_a.getStateForPlacement(worldIn, pos, facing, 0.0f, 0.0f, 0.0f, itemstack.func_77960_j(), null, EnumHand.MAIN_HAND));
    }

    @Optional.Method(modid="mcmultipart")
    protected abstract IMultipart getMultiPart();

    public boolean func_179222_a(World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side, @Nonnull EntityPlayer player, ItemStack stack) {
        return super.func_179222_a(worldIn, pos, side, player, stack) || Mekanism.hooks.MCMPLoaded && MultipartHelper.getContainer((IBlockAccess)worldIn, (BlockPos)pos).isPresent();
    }

    public boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState newState) {
        if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            return false;
        }
        return super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
    }
}

