/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.BlockTFPlant;
import twilightforest.block.TFBlocks;
import twilightforest.entity.EntityTFMosquitoSwarm;
import twilightforest.enums.PlantVariant;
import twilightforest.world.feature.TFGenHugeLilyPad;
import twilightforest.world.feature.TFGenHugeWaterLily;
import twilightforest.world.feature.TFGenTallGrass;
import twilightforest.world.feature.TFGenVines;

public class TFBiomeSwamp
extends TFBiomeBase {
    private static final int MONSTER_SPAWN_RATE = 20;
    private final Random monsterRNG = new Random(53439L);
    private final WorldGenerator vinesGen = new TFGenVines();
    private final WorldGenerator hugeLilyPadGen = new TFGenHugeLilyPad();
    private final WorldGenerator hugeWaterLilyGen = new TFGenHugeWaterLily();

    public TFBiomeSwamp(Biome.BiomeProperties props) {
        super(props);
        this.getTFBiomeDecorator().setDeadBushPerChunk(1);
        this.getTFBiomeDecorator().setMushroomsPerChunk(8);
        this.getTFBiomeDecorator().setReedsPerChunk(10);
        this.getTFBiomeDecorator().setClayPerChunk(1);
        this.getTFBiomeDecorator().setTreesPerChunk(2);
        this.getTFBiomeDecorator().setWaterlilyPerChunk(20);
        this.getTFBiomeDecorator().hasCanopy = false;
        this.getTFBiomeDecorator().lakesPerChunk = 2;
        this.getTFBiomeDecorator().mangrovesPerChunk = 3;
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityTFMosquitoSwarm.class, 10, 1, 1));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityCreeper.class, 10, 4, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityZombie.class, 10, 4, 4));
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(3) == 0) {
            return new WorldGenShrub(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK));
        }
        return field_76763_Q;
    }

    @Override
    public WorldGenerator func_76730_b(Random random) {
        if (random.nextInt(4) == 0) {
            return new WorldGenTallGrass(BlockTallGrass.EnumType.FERN);
        }
        if (random.nextInt(4) == 0) {
            return new TFGenTallGrass(TFBlocks.twilight_plant.func_176223_P().func_177226_a(BlockTFPlant.VARIANT, (Comparable)((Object)PlantVariant.MAYAPPLE)));
        }
        return new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    public void func_180624_a(World world, Random random, BlockPos pos) {
        int z;
        int y;
        int x;
        int i;
        super.func_180624_a(world, random, pos);
        for (i = 0; i < 50; ++i) {
            x = pos.func_177958_n() + random.nextInt(16) + 8;
            y = 159;
            z = pos.func_177952_p() + random.nextInt(16) + 8;
            this.vinesGen.func_180709_b(world, random, new BlockPos(x, y, z));
        }
        for (i = 0; i < 25; ++i) {
            x = pos.func_177958_n() + random.nextInt(15) + 8;
            y = 31;
            z = pos.func_177952_p() + random.nextInt(15) + 8;
            this.hugeLilyPadGen.func_180709_b(world, random, new BlockPos(x, y, z));
        }
        for (i = 0; i < 2; ++i) {
            x = pos.func_177958_n() + random.nextInt(16) + 8;
            y = 31;
            z = pos.func_177952_p() + random.nextInt(16) + 8;
            this.hugeWaterLilyGen.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }

    public int func_180627_b(BlockPos pos) {
        double temperature = MathHelper.func_76131_a((float)this.func_180626_a(pos), (float)0.0f, (float)1.0f);
        double humidity = MathHelper.func_76131_a((float)this.func_76727_i(), (float)0.0f, (float)1.0f);
        return ((ColorizerGrass.func_77480_a((double)temperature, (double)humidity) & 0xFEFEFE) + 0x4E0E4E) / 2;
    }

    public int func_180625_c(BlockPos pos) {
        double temperature = MathHelper.func_76131_a((float)this.func_180626_a(pos), (float)0.0f, (float)1.0f);
        double humidity = MathHelper.func_76131_a((float)this.func_76727_i(), (float)0.0f, (float)1.0f);
        return ((ColorizerFoliage.func_77470_a((double)temperature, (double)humidity) & 0xFEFEFE) + 0x4E0E4E) / 2;
    }

    public List<Biome.SpawnListEntry> func_76747_a(EnumCreatureType creatureType) {
        if (creatureType == EnumCreatureType.MONSTER) {
            return this.monsterRNG.nextInt(20) == 0 ? this.field_76761_J : new ArrayList();
        }
        return super.func_76747_a(creatureType);
    }

    @Override
    protected ResourceLocation[] getRequiredAdvancements() {
        return new ResourceLocation[]{TwilightForestMod.prefix("progress_lich")};
    }

    @Override
    public void enforceProgression(EntityPlayer player, World world) {
        if (!world.field_72995_K && player.field_70173_aa % 60 == 0) {
            PotionEffect currentHunger = player.func_70660_b(MobEffects.field_76438_s);
            int hungerLevel = currentHunger != null ? currentHunger.func_76458_c() + 1 : 1;
            player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 100, hungerLevel));
            if (world.field_73012_v.nextInt(4) == 0) {
                TFFeature.LABYRINTH.trySpawnHintMonster(world, player);
            }
        }
    }
}

