/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import twilightforest.TwilightForestMod;

public abstract class EntityAITFHoverBase<T extends EntityLiving>
extends EntityAIBase {
    protected final Class<? extends EntityLivingBase> classTarget;
    protected final T attacker;
    protected final float hoverHeight;
    protected final float hoverRadius;
    protected double hoverPosX;
    protected double hoverPosY;
    protected double hoverPosZ;

    protected EntityAITFHoverBase(T snowQueen, Class<? extends EntityLivingBase> targetClass, float hoverHeight, float hoverRadius) {
        this.classTarget = targetClass;
        this.attacker = snowQueen;
        this.hoverHeight = hoverHeight;
        this.hoverRadius = hoverRadius;
    }

    public void func_75249_e() {
        EntityLivingBase target = this.attacker.func_70638_az();
        if (target != null) {
            this.makeNewHoverSpot(target);
        }
    }

    protected void makeNewHoverSpot(EntityLivingBase target) {
        double hx = 0.0;
        double hy = 0.0;
        double hz = 0.0;
        boolean found = false;
        for (int i = 0; i < 100; ++i) {
            hx = target.field_70165_t + (double)((this.attacker.func_70681_au().nextFloat() - this.attacker.func_70681_au().nextFloat()) * this.hoverRadius);
            if (this.isPositionOccupied(hx, hy = target.field_70163_u + (double)this.hoverHeight, hz = target.field_70161_v + (double)((this.attacker.func_70681_au().nextFloat() - this.attacker.func_70681_au().nextFloat()) * this.hoverRadius)) || !this.canEntitySee((Entity)this.attacker, hx, hy, hz) || !this.canEntitySee((Entity)target, hx, hy, hz)) continue;
            found = true;
            break;
        }
        if (!found) {
            TwilightForestMod.LOGGER.debug("Found no spots, giving up");
        }
        this.hoverPosX = hx;
        this.hoverPosY = hy;
        this.hoverPosZ = hz;
    }

    protected boolean isPositionOccupied(double hx, double hy, double hz) {
        float radius = ((EntityLiving)this.attacker).field_70130_N / 2.0f;
        AxisAlignedBB aabb = new AxisAlignedBB(hx - (double)radius, hy, hz - (double)radius, hx + (double)radius, hy + (double)((EntityLiving)this.attacker).field_70131_O, hz + (double)radius);
        return !((EntityLiving)this.attacker).field_70170_p.func_72917_a(aabb, this.attacker) || !((EntityLiving)this.attacker).field_70170_p.func_184144_a(this.attacker, aabb).isEmpty();
    }

    protected boolean canEntitySee(Entity entity, double dx, double dy, double dz) {
        return entity.field_70170_p.func_72933_a(new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), new Vec3d(dx, dy, dz)) == null;
    }
}

