/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketMaps;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.TFMazeMapData;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.item.TFItems;
import twilightforest.network.PacketMazeMap;
import twilightforest.network.TFPacketHandler;

public class ItemTFMazeMap
extends ItemMap
implements ModelRegisterCallback {
    public static final String STR_ID = "mazemap";
    private static final int YSEARCH = 3;
    protected final boolean mapOres;

    protected ItemTFMazeMap(boolean mapOres) {
        this.mapOres = mapOres;
    }

    public static ItemStack setupNewMap(World world, double worldX, double worldZ, byte scale, boolean trackingPosition, boolean unlimitedTracking, double worldY, boolean mapOres) {
        ItemStack itemstack = new ItemStack(mapOres ? TFItems.ore_map : TFItems.maze_map, 1, world.func_72841_b(STR_ID));
        String s = "mazemap_" + itemstack.func_77960_j();
        TFMazeMapData mapdata = new TFMazeMapData(s);
        world.func_72823_a(s, (WorldSavedData)mapdata);
        mapdata.field_76197_d = scale;
        mapdata.calculateMapCenter(world, worldX, worldY, worldZ, scale);
        mapdata.field_76200_c = world.field_73011_w.getDimension();
        mapdata.field_186210_e = trackingPosition;
        mapdata.field_191096_f = unlimitedTracking;
        mapdata.func_76185_a();
        return itemstack;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public static TFMazeMapData loadMapData(int mapId, World world) {
        String s = "mazemap_" + mapId;
        return (TFMazeMapData)world.func_72943_a(TFMazeMapData.class, s);
    }

    public TFMazeMapData getMapData(ItemStack stack, World worldIn) {
        String s = "mazemap_" + stack.func_77960_j();
        TFMazeMapData mapdata = (TFMazeMapData)worldIn.func_72943_a(TFMazeMapData.class, s);
        if (mapdata == null && !worldIn.field_72995_K) {
            stack.func_77964_b(worldIn.func_72841_b(STR_ID));
            s = "mazemap_" + stack.func_77960_j();
            mapdata = new TFMazeMapData(s);
            mapdata.field_76197_d = 0;
            mapdata.func_176054_a(worldIn.func_72912_H().func_76079_c(), worldIn.func_72912_H().func_76074_e(), mapdata.field_76197_d);
            mapdata.field_76200_c = worldIn.field_73011_w.getDimension();
            mapdata.func_76185_a();
            worldIn.func_72823_a(s, (WorldSavedData)mapdata);
        }
        return mapdata;
    }

    public void func_77872_a(World world, Entity viewer, MapData data) {
        if (world.field_73011_w.getDimension() == data.field_76200_c && viewer instanceof EntityPlayer) {
            int blocksPerPixel = 1 << data.field_76197_d;
            int centerX = data.field_76201_a;
            int centerZ = data.field_76199_b;
            int viewerX = MathHelper.func_76128_c((double)(viewer.field_70165_t - (double)centerX)) / blocksPerPixel + 64;
            int viewerZ = MathHelper.func_76128_c((double)(viewer.field_70161_v - (double)centerZ)) / blocksPerPixel + 64;
            int viewRadiusPixels = 16;
            if (world.field_73011_w.func_177495_o()) {
                viewRadiusPixels /= 2;
            }
            MapData.MapInfo mapdata$mapinfo = data.func_82568_a((EntityPlayer)viewer);
            ++mapdata$mapinfo.field_82569_d;
            boolean flag = false;
            for (int xPixel = viewerX - viewRadiusPixels + 1; xPixel < viewerX + viewRadiusPixels; ++xPixel) {
                if ((xPixel & 0xF) != (mapdata$mapinfo.field_82569_d & 0xF) && !flag) continue;
                flag = false;
                double d0 = 0.0;
                for (int zPixel = viewerZ - viewRadiusPixels - 1; zPixel < viewerZ + viewRadiusPixels; ++zPixel) {
                    byte b1;
                    byte b0;
                    if (xPixel < 0 || zPixel < -1 || xPixel >= 128 || zPixel >= 128) continue;
                    int xPixelDist = xPixel - viewerX;
                    int zPixelDist = zPixel - viewerZ;
                    boolean shouldFuzz = xPixelDist * xPixelDist + zPixelDist * zPixelDist > (viewRadiusPixels - 2) * (viewRadiusPixels - 2);
                    int worldX = (centerX / blocksPerPixel + xPixel - 64) * blocksPerPixel;
                    int worldZ = (centerZ / blocksPerPixel + zPixel - 64) * blocksPerPixel;
                    HashMultiset multiset = HashMultiset.create();
                    Chunk chunk = world.func_175726_f(new BlockPos(worldX, 0, worldZ));
                    int brightness = 1;
                    if (chunk.func_76621_g()) continue;
                    int worldXRounded = worldX & 0xF;
                    int worldZRounded = worldZ & 0xF;
                    boolean numLiquid = false;
                    double d1 = 0.0;
                    if (world.field_73011_w.func_177495_o()) {
                        int l3 = worldX + worldZ * 231871;
                        if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT).func_185909_g((IBlockAccess)world, BlockPos.field_177992_a), 10);
                        } else {
                            multiset.add((Object)Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.STONE).func_185909_g((IBlockAccess)world, BlockPos.field_177992_a), 100);
                        }
                        d1 = 100.0;
                    } else {
                        int yCenter = ((TFMazeMapData)data).yCenter;
                        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(worldXRounded, yCenter, worldZRounded);
                        IBlockState state = chunk.func_177435_g((BlockPos)blockpos$mutableblockpos);
                        multiset.add((Object)state.func_185909_g((IBlockAccess)world, (BlockPos)blockpos$mutableblockpos));
                        if (state.func_177230_c() == Blocks.field_150348_b || state.func_177230_c() == Blocks.field_150350_a) {
                            for (int i = -3; i <= 3; ++i) {
                                blockpos$mutableblockpos.func_185336_p(yCenter + i);
                                IBlockState searchID = chunk.func_177435_g((BlockPos)blockpos$mutableblockpos);
                                if (searchID.func_177230_c() == Blocks.field_150348_b || searchID.func_177230_c() == Blocks.field_150350_a) continue;
                                state = searchID;
                                if (i > 0) {
                                    brightness = 2;
                                }
                                if (i >= 0) break;
                                brightness = 0;
                                break;
                            }
                        }
                        if (this.mapOres) {
                            if (state.func_177230_c() == Blocks.field_150365_q) {
                                multiset.add((Object)MapColor.field_151646_E, 1000);
                            } else if (state.func_177230_c() == Blocks.field_150352_o) {
                                multiset.add((Object)MapColor.field_151647_F, 1000);
                            } else if (state.func_177230_c() == Blocks.field_150366_p) {
                                multiset.add((Object)MapColor.field_151668_h, 1000);
                            } else if (state.func_177230_c() == Blocks.field_150369_x) {
                                multiset.add((Object)MapColor.field_151652_H, 1000);
                            } else if (state.func_177230_c() == Blocks.field_150450_ax || state.func_177230_c() == Blocks.field_150439_ay) {
                                multiset.add((Object)MapColor.field_151645_D, 1000);
                            } else if (state.func_177230_c() == Blocks.field_150482_ag) {
                                multiset.add((Object)MapColor.field_151648_G, 1000);
                            } else if (state.func_177230_c() == Blocks.field_150412_bA) {
                                multiset.add((Object)MapColor.field_151653_I, 1000);
                            } else if (state.func_177230_c() != Blocks.field_150350_a && state.func_177230_c().getRegistryName().func_110623_a().contains("ore")) {
                                multiset.add((Object)MapColor.field_151671_v, 1000);
                            }
                        }
                    }
                    MapColor mapcolor = (MapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MapColor.field_151660_b);
                    d0 = d1;
                    if (zPixel < 0 || xPixelDist * xPixelDist + zPixelDist * zPixelDist >= viewRadiusPixels * viewRadiusPixels || shouldFuzz && (xPixel + zPixel & 1) == 0 || (b0 = data.field_76198_e[xPixel + zPixel * 128]) == (b1 = (byte)(mapcolor.field_76290_q * 4 + brightness))) continue;
                    data.field_76198_e[xPixel + zPixel * 128] = b1;
                    data.func_176053_a(xPixel, zPixel);
                    flag = true;
                }
            }
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int slot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            TFMazeMapData mapdata = this.getMapData(stack, worldIn);
            if (entityIn instanceof EntityPlayer) {
                MapDecoration decoration;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                mapdata.func_76191_a(entityplayer, stack);
                int yProximity = MathHelper.func_76128_c((double)(entityplayer.field_70163_u - (double)mapdata.yCenter));
                if ((yProximity < -3 || yProximity > 3) && (decoration = (MapDecoration)mapdata.field_76203_h.get(entityplayer.func_70005_c_())) != null) {
                    mapdata.field_76203_h.put(entityplayer.func_70005_c_(), new MapDecoration(MapDecoration.Type.PLAYER_OFF_MAP, decoration.func_176112_b(), decoration.func_176113_c(), decoration.func_176111_d()));
                }
            }
            if (isSelected || entityIn instanceof EntityPlayer && ((EntityPlayer)entityIn).func_184592_cb() == stack) {
                this.func_77872_a(worldIn, entityIn, mapdata);
            }
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.mapOres ? EnumRarity.UNCOMMON : EnumRarity.COMMON;
    }

    @Nullable
    public Packet<?> func_150911_c(ItemStack stack, World worldIn, EntityPlayer player) {
        Packet p = super.func_150911_c(stack, worldIn, player);
        if (p instanceof SPacketMaps) {
            return TFPacketHandler.CHANNEL.getPacketFrom((IMessage)new PacketMazeMap((SPacketMaps)p));
        }
        return p;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

