/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import twilightforest.TFConfig;
import twilightforest.TFFeature;
import twilightforest.biomes.TFBiomes;
import twilightforest.block.TFBlocks;
import twilightforest.util.IntPair;
import twilightforest.world.ChunkBitArray;
import twilightforest.world.ChunkGeneratorTFBase;
import twilightforest.world.DirectChunkPrimer;
import twilightforest.world.MapGenTFMajorFeature;
import twilightforest.world.TFGenCaves;
import twilightforest.world.TFGenRavine;

public class ChunkGeneratorTwilightForest
extends ChunkGeneratorTFBase {
    private final NoiseGeneratorOctaves noiseGen4;
    private final TFGenCaves caveGenerator = new TFGenCaves();
    private final TFGenRavine ravineGenerator = new TFGenRavine();

    public ChunkGeneratorTwilightForest(World world, long seed, boolean enableFeatures) {
        super(world, seed, enableFeatures, true);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed(ChunkGeneratorTwilightForest.getSeed(x, z));
        ChunkBitArray data = new ChunkBitArray();
        this.setBlocksInChunk(x, z, data);
        this.squishTerrain(data);
        DirectChunkPrimer primer = new DirectChunkPrimer();
        this.initPrimer(primer, data);
        this.addDarkForestCanopy2(x, z, primer);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.addGlaciers(x, z, primer, this.biomesForGeneration);
        this.deformTerrainForFeature(x, z, primer);
        this.replaceBiomeBlocks(x, z, primer, this.biomesForGeneration);
        this.caveGenerator.func_186125_a(this.world, x, z, primer);
        this.ravineGenerator.func_186125_a(this.world, x, z, primer);
        this.generateFeatures(x, z, primer);
        this.hollowTreeGenerator.func_186125_a(this.world, x, z, primer);
        return this.makeChunk(x, z, primer);
    }

    @Override
    protected void initPrimer(ChunkPrimer primer, ChunkBitArray data) {
        IBlockState water = Blocks.field_150355_j.func_176223_P();
        IBlockState stone = Blocks.field_150348_b.func_176223_P();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 256; ++y) {
                    boolean solid = data.get(ChunkGeneratorTwilightForest.getIndex(x, y, z));
                    if (y < 31 && !solid) {
                        primer.func_177855_a(x, y, z, water);
                        continue;
                    }
                    if (!solid) continue;
                    primer.func_177855_a(x, y, z, stone);
                }
            }
        }
    }

    private void addGlaciers(int chunkX, int chunkZ, ChunkPrimer primer, Biome[] biomes) {
        IBlockState glacierBase = Blocks.field_150351_n.func_176223_P();
        IBlockState glacierMain = TFConfig.performance.glacierPackedIce ? Blocks.field_150403_cj.func_176223_P() : Blocks.field_150432_aD.func_176223_P();
        IBlockState glacierTop = Blocks.field_150432_aD.func_176223_P();
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                Biome biome = biomes[x & 0xF | (z & 0xF) << 4];
                if (biome != TFBiomes.glacier) continue;
                int gBase = -1;
                for (int y = 127; y >= 0; --y) {
                    Block currentBlock = primer.func_177856_a(x, y, z).func_177230_c();
                    if (currentBlock != Blocks.field_150348_b) continue;
                    gBase = y + 1;
                    primer.func_177855_a(x, y, z, glacierBase);
                    break;
                }
                int gHeight = 32;
                int gTop = Math.min(gBase + gHeight, 127);
                for (int y = gBase; y < gTop; ++y) {
                    primer.func_177855_a(x, y, z, glacierMain);
                }
                primer.func_177855_a(x, gTop, z, glacierTop);
            }
        }
    }

    private void addDarkForestCanopy2(int chunkX, int chunkZ, ChunkPrimer primer) {
        int[] thicks = new int[25];
        for (int z = 0; z < 5; ++z) {
            for (int x = 0; x < 5; ++x) {
                for (int bx = -1; bx <= 1; ++bx) {
                    for (int bz = -1; bz <= 1; ++bz) {
                        Biome biome = this.biomesForGeneration[x + bx + 2 + (z + bz + 2) * 10];
                        if (biome != TFBiomes.darkForest && biome != TFBiomes.darkForestCenter) continue;
                        int n = x + z * 5;
                        thicks[n] = thicks[n] + 1;
                    }
                }
            }
        }
        IntPair nearCenter = new IntPair();
        TFFeature nearFeature = TFFeature.getNearestFeature(chunkX, chunkZ, this.world, nearCenter);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                Block currentBlock;
                boolean generateForest;
                int hz;
                int dz;
                int hx;
                int dx;
                int dist;
                int qx = x / 4;
                int qz = z / 4;
                float xweight = (float)(x % 4) * 0.25f + 0.125f;
                float zweight = (float)(z % 4) * 0.25f + 0.125f;
                float thickness = 0.0f;
                thickness += (float)thicks[qx + qz * 5] * (1.0f - xweight) * (1.0f - zweight);
                thickness += (float)thicks[qx + 1 + qz * 5] * xweight * (1.0f - zweight);
                thickness += (float)thicks[qx + (qz + 1) * 5] * (1.0f - xweight) * zweight;
                thickness += (float)thicks[qx + 1 + (qz + 1) * 5] * xweight * zweight;
                thickness -= 4.0f;
                if (nearFeature == TFFeature.DARK_TOWER && (dist = (int)Math.sqrt((dx = x - (hx = nearCenter.x)) * dx + (dz = z - (hz = nearCenter.z)) * dz)) < 24) {
                    thickness -= (float)(24 - dist);
                }
                boolean bl = generateForest = thickness > 1.0f;
                if (!generateForest) continue;
                double d = 0.03125;
                this.depthBuffer = this.noiseGen4.func_76304_a(this.depthBuffer, chunkX * 16, chunkZ * 16, 0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
                int topLevel = -1;
                for (int y = 127; y >= 0 && (currentBlock = primer.func_177856_a(x, y, z).func_177230_c()) != Blocks.field_150355_j; --y) {
                    if (currentBlock != Blocks.field_150348_b) continue;
                    topLevel = y;
                    break;
                }
                if (topLevel == -1) continue;
                int noise = Math.min(3, (int)(this.depthBuffer[z & 0xF | (x & 0xF) << 4] / 1.25));
                int treeBottom = topLevel + 12 - (int)(thickness * 0.5f);
                int treeTop = treeBottom + (int)(thickness * 1.5f);
                for (int y = treeBottom -= noise; y < treeTop; ++y) {
                    primer.func_177855_a(x, y, z, TFBlocks.dark_leaves.func_176223_P());
                }
            }
        }
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        boolean flag = false;
        ChunkPos chunkpos = new ChunkPos(x, z);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        boolean disableFeatures = false;
        for (MapGenTFMajorFeature generator : this.featureGenerators.values()) {
            if (!generator.func_175794_a(this.world, this.rand, chunkpos)) continue;
            disableFeatures = true;
        }
        disableFeatures = disableFeatures || !TFFeature.getNearestFeature((int)x, (int)z, (World)this.world).areChunkDecorationsEnabled;
        this.hollowTreeGenerator.func_175794_a(this.world, this.rand, chunkpos);
        if (!disableFeatures && this.rand.nextInt(4) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)x, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            int i1 = blockpos.func_177958_n() + this.rand.nextInt(16) + 8;
            int i2 = this.rand.nextInt(256);
            int i3 = blockpos.func_177952_p() + this.rand.nextInt(16) + 8;
            if (i2 < 31 || this.allowSurfaceLakes(biome)) {
                new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.rand, new BlockPos(i1, i2, i3));
            }
        }
        if (!disableFeatures && this.rand.nextInt(32) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
            int j1 = blockpos.func_177958_n() + this.rand.nextInt(16) + 8;
            int j2 = this.rand.nextInt(this.rand.nextInt(248) + 8);
            int j3 = blockpos.func_177952_p() + this.rand.nextInt(16) + 8;
            if (j2 < 31 || this.allowSurfaceLakes(biome) && this.rand.nextInt(10) == 0) {
                new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.world, this.rand, new BlockPos(j1, j2, j3));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
            for (int k1 = 0; k1 < 8; ++k1) {
                int k2 = blockpos.func_177958_n() + this.rand.nextInt(16) + 8;
                int k3 = this.rand.nextInt(256);
                int l3 = blockpos.func_177952_p() + this.rand.nextInt(16) + 8;
                new WorldGenDungeons().func_180709_b(this.world, this.rand, new BlockPos(k2, k3, l3));
            }
        }
        biome.func_180624_a(this.world, this.rand, new BlockPos(i, 0, j));
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
        }
        blockpos = blockpos.func_177982_a(8, 0, 8);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    BlockPos blockpos1 = this.world.func_175725_q(blockpos.func_177982_a(k2, 0, j3));
                    BlockPos blockpos2 = blockpos1.func_177977_b();
                    if (this.world.func_175675_v(blockpos2)) {
                        this.world.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 18);
                    }
                    if (!this.world.func_175708_f(blockpos1, true)) continue;
                    this.world.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 18);
                }
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        BlockFalling.field_149832_M = false;
    }

    @Override
    public void func_180514_a(Chunk chunk, int x, int z) {
        super.func_180514_a(chunk, x, z);
        this.hollowTreeGenerator.func_186125_a(this.world, x, z, null);
    }
}

