/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import java.util.List;
import java.util.function.BiFunction;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.api.Infusable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.crafting.INBTPreservingIngredient;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleSupport;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.shield.GuiShield;
import mcjty.rftools.blocks.shield.ShieldContainer;
import mcjty.rftools.blocks.shield.ShieldTEBase;
import mcjty.rftools.items.smartwrench.SmartWrenchItem;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ShieldBlock
extends GenericRFToolsBlock<ShieldTEBase, ShieldContainer>
implements Infusable,
INBTPreservingIngredient {
    private final int max;

    public ShieldBlock(String blockName, Class<? extends ShieldTEBase> clazz, int max) {
        super(Material.field_151573_f, clazz, ShieldContainer::new, blockName, true);
        this.max = max;
    }

    public boolean needsRedstoneCheck() {
        return true;
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.NONE;
    }

    @SideOnly(value=Side.CLIENT)
    public BiFunction<ShieldTEBase, ShieldContainer, GenericGuiContainer<? super ShieldTEBase>> getGuiFactory() {
        return GuiShield::new;
    }

    public int getGuiID() {
        return GuiProxy.GUI_SHIELD;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        list.add(TextFormatting.GREEN + "Supports " + this.max + " blocks");
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This machine forms a shield out of adjacent");
            list.add(TextFormatting.WHITE + "template blocks. It can filter based on type of");
            list.add(TextFormatting.WHITE + "mob and do various things (damage, solid, ...)");
            list.add(TextFormatting.WHITE + "Use the Smart Wrench to add sections to the shield");
            list.add(TextFormatting.RED + "Note: block mimic is not implemented yet!");
            list.add(TextFormatting.YELLOW + "Infusing bonus: reduced power consumption and");
            list.add(TextFormatting.YELLOW + "increased damage.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    protected IModuleSupport getModuleSupport() {
        return new ModuleSupport(1){

            public boolean isModule(ItemStack itemStack) {
                return itemStack.func_77973_b() == BuilderSetup.shapeCardItem;
            }
        };
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.restoreBlockFromNBT(world, pos, stack);
        this.setOwner(world, pos, placer);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer playerIn) {
        if (!world.field_72995_K) {
            this.composeDecomposeShield(world, pos, true);
        }
    }

    protected boolean wrenchUse(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        this.composeDecomposeShield(world, pos, false);
        return true;
    }

    protected boolean wrenchSneakSelect(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K) {
            GlobalCoordinate currentBlock = SmartWrenchItem.getCurrentBlock(player.func_184586_b(EnumHand.MAIN_HAND));
            if (currentBlock == null) {
                SmartWrenchItem.setCurrentBlock(player.func_184586_b(EnumHand.MAIN_HAND), new GlobalCoordinate(pos, world.field_73011_w.getDimension()));
                Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Selected block"));
            } else {
                SmartWrenchItem.setCurrentBlock(player.func_184586_b(EnumHand.MAIN_HAND), null);
                Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Cleared selected block"));
            }
        }
        return true;
    }

    private void composeDecomposeShield(World world, BlockPos pos, boolean ctrl) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof ShieldTEBase) {
            ((ShieldTEBase)te).composeDecomposeShield(ctrl);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        ShieldTEBase shieldTileEntity;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ShieldTEBase && !world.field_72995_K && (shieldTileEntity = (ShieldTEBase)te).isShieldComposed()) {
            shieldTileEntity.decomposeShield();
        }
        super.func_180663_b(world, pos, state);
    }
}

