/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.common.Lang;
import com.enderio.core.common.network.EnderPacketHandler;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChatUtil {
    private static final int DELETION_ID = 8675309;
    private static int lastAdded;

    static void sendNoSpamMessages(ITextComponent[] messages) {
        int i;
        GuiNewChat chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        for (i = 8675309 + messages.length - 1; i <= lastAdded; ++i) {
            chat.func_146242_c(i);
        }
        for (i = 0; i < messages.length; ++i) {
            ITextComponent chatComponent = messages[i];
            if (chatComponent == null) continue;
            chat.func_146234_a(chatComponent, 8675309 + i);
        }
        lastAdded = 8675309 + messages.length - 1;
    }

    @Nonnull
    public static ITextComponent wrap(@Nullable String s) {
        return s == null ? new TextComponentString("") : new TextComponentString(s);
    }

    @Nonnull
    public static ITextComponent[] wrap(String ... s) {
        ITextComponent[] ret = new ITextComponent[s.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ChatUtil.wrap(s[i]);
        }
        return ret;
    }

    @Nonnull
    public static ITextComponent wrapFormatted(@Nonnull String s, Object ... args) {
        return new TextComponentTranslation(s, args);
    }

    public static void sendChat(@Nonnull EntityPlayer player, String ... lines) {
        ChatUtil.sendChat(player, ChatUtil.wrap(lines));
    }

    public static void sendChatUnloc(@Nonnull EntityPlayer player, @Nonnull Lang lang, String ... unlocLines) {
        ChatUtil.sendChat(player, lang.localizeAll(lang, unlocLines));
    }

    public static void sendChat(@Nonnull EntityPlayer player, ITextComponent ... lines) {
        for (ITextComponent c : lines) {
            if (c == null) continue;
            player.func_145747_a(c);
        }
    }

    public static void sendNoSpamClientUnloc(@Nonnull Lang lang, String ... unlocLines) {
        ChatUtil.sendNoSpamClient(lang.localizeAll(lang, unlocLines));
    }

    public static void sendNoSpamClient(String ... lines) {
        ChatUtil.sendNoSpamClient(ChatUtil.wrap(lines));
    }

    public static void sendNoSpamClient(ITextComponent ... lines) {
        ChatUtil.sendNoSpamMessages(lines);
    }

    public static void sendNoSpamUnloc(@Nonnull EntityPlayer player, @Nonnull Lang lang, String ... unlocLines) {
        ChatUtil.sendNoSpam(player, lang.localizeAll(lang, unlocLines));
    }

    public static void sendNoSpam(@Nonnull EntityPlayer player, String ... lines) {
        ChatUtil.sendNoSpam(player, ChatUtil.wrap(lines));
    }

    public static void sendNoSpam(@Nonnull EntityPlayer player, ITextComponent ... lines) {
        if (player instanceof EntityPlayerMP) {
            ChatUtil.sendNoSpam((EntityPlayerMP)player, lines);
        }
    }

    public static void sendNoSpamUnloc(@Nonnull EntityPlayerMP player, @Nonnull Lang lang, String ... unlocLines) {
        ChatUtil.sendNoSpam(player, lang.localizeAll(lang, unlocLines));
    }

    public static void sendNoSpam(@Nonnull EntityPlayerMP player, String ... lines) {
        ChatUtil.sendNoSpam(player, ChatUtil.wrap(lines));
    }

    public static void sendNoSpam(@Nonnull EntityPlayerMP player, ITextComponent ... lines) {
        if (lines.length > 0) {
            EnderPacketHandler.INSTANCE.sendTo(new PacketNoSpamChat(lines), player);
        }
    }

    public static class PacketNoSpamChat
    implements IMessage {
        ITextComponent[] chatLines;

        public PacketNoSpamChat() {
            this.chatLines = new ITextComponent[0];
        }

        PacketNoSpamChat(ITextComponent ... lines) {
            this.chatLines = lines;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.chatLines.length);
            for (ITextComponent c : this.chatLines) {
                if (c == null) continue;
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)ITextComponent.Serializer.func_150696_a((ITextComponent)c));
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.chatLines = new ITextComponent[buf.readInt()];
            for (int i = 0; i < this.chatLines.length; ++i) {
                String readUTF8String = ByteBufUtils.readUTF8String((ByteBuf)buf);
                this.chatLines[i] = readUTF8String == null ? new TextComponentString("") : ITextComponent.Serializer.func_150699_a((String)readUTF8String);
            }
        }

        public static class Handler
        implements IMessageHandler<PacketNoSpamChat, IMessage> {
            public IMessage onMessage(PacketNoSpamChat message, MessageContext ctx) {
                ChatUtil.sendNoSpamMessages(message.chatLines);
                return null;
            }
        }
    }
}

