/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.rwtema.careerbees.BeeMod;
import com.rwtema.careerbees.ClientFunction;
import com.rwtema.careerbees.ClientRunnable;
import com.rwtema.careerbees.ModelDelegate;
import com.rwtema.careerbees.Proxy;
import com.rwtema.careerbees.bees.CustomBeeModel;
import com.rwtema.careerbees.blocks.TESRPlantFrame;
import com.rwtema.careerbees.blocks.TileFlowerPedastal;
import com.rwtema.careerbees.commands.CommandColors;
import com.rwtema.careerbees.entity.EntityBeeSwarm;
import com.rwtema.careerbees.entity.RenderBeeSwarm;
import com.rwtema.careerbees.items.ItemIngredients;
import com.rwtema.careerbees.tooltip.TooltipHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BakedQuadRetextured;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class ProxyClient
extends Proxy {
    static final HashMap<TextureAtlasSprite, ModelBark> models = new HashMap();
    public static TextureAtlasSprite exclamation_sprite;
    public static TextureAtlasSprite beeSprite;
    public static TextureAtlasSprite blankSprite;

    public ProxyClient() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private static String wrap(@Nonnull Object k) {
        String s = k.toString();
        return s.toLowerCase().replaceAll("[\\s\\.]+", "_");
    }

    @Override
    public void preInit() {
        RenderingRegistry.registerEntityRenderingHandler(EntityBeeSwarm.class, RenderBeeSwarm::new);
        this.registerBlockModel(BeeMod.instance.plantFrameItemBlock);
        this.registerBlockModel(BeeMod.instance.alvearyHiveFrameHolderItemBlock);
        this.registerModel(BeeMod.instance.itemPheremoneFrame);
        this.registerModel(BeeMod.instance.itemMutationFrame);
        this.registerModel(BeeMod.instance.itemEternalFrame);
        this.registerModel(BeeMod.instance.itemBeeGun);
        this.registerModel(BeeMod.instance.itemPoisonFrame);
        this.registerModel(BeeMod.instance.itemSettingsFrame);
        BeeMod.instance.beeArmors.values().forEach(this::registerModel);
        EnumMap<ItemIngredients.IngredientType, ModelResourceLocation> map = new EnumMap<ItemIngredients.IngredientType, ModelResourceLocation>(ItemIngredients.IngredientType.class);
        for (ItemIngredients.IngredientType ingredientType : ItemIngredients.IngredientType.values()) {
            ModelResourceLocation modelResourceLocation;
            ResourceLocation registryName = BeeMod.instance.itemIngredients.getRegistryName();
            ingredientType.mrl = modelResourceLocation = new ModelResourceLocation(ProxyClient.wrap(registryName + "." + ingredientType.name().toLowerCase(Locale.ENGLISH)), "inventory");
            map.put(ingredientType, modelResourceLocation);
            ModelLoader.setCustomModelResourceLocation((Item)BeeMod.instance.itemIngredients, (int)ingredientType.meta, (ModelResourceLocation)modelResourceLocation);
            ModelBakery.registerItemVariants((Item)BeeMod.instance.itemIngredients, (ResourceLocation[])new ResourceLocation[]{modelResourceLocation});
            if (Proxy.itemModelHook == null) continue;
            Proxy.itemModelHook.accept(modelResourceLocation);
        }
        ModelLoader.setCustomMeshDefinition((Item)BeeMod.instance.itemIngredients, stack -> (ModelResourceLocation)map.get(ItemIngredients.getIngredientType(stack)));
        if (BeeMod.deobf) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandColors());
        }
        CustomBeeModel.SUFFIXES.forEach(CustomBeeModel::registerModels);
        new TooltipHandler().init();
    }

    @SubscribeEvent
    public void registerTexture(@Nonnull TextureStitchEvent.Pre event) {
        exclamation_sprite = event.getMap().func_174942_a(new ResourceLocation("careerbees", "items/exclamation"));
        blankSprite = event.getMap().func_174942_a(new ResourceLocation("careerbees", "items/blank"));
        beeSprite = event.getMap().func_174942_a(new ResourceLocation("forestry:entity/particles/swarm_bee"));
    }

    @SubscribeEvent
    public void registerModels(@Nonnull ModelBakeEvent event) {
        IRegistry modelRegistry = event.getModelRegistry();
        models.clear();
        IBakedModel base = (IBakedModel)modelRegistry.func_82594_a((Object)ItemIngredients.IngredientType.BARK.mrl);
        if (base != null && !(base instanceof ModelWithOverrides)) {
            modelRegistry.func_82595_a((Object)ItemIngredients.IngredientType.BARK.mrl, (Object)new ModelWithOverrides(base){

                @Override
                @Nullable
                public IBakedModel handleItemState(IBakedModel originalModel, @Nonnull ItemStack stack, World world, EntityLivingBase entity) {
                    NBTTagCompound tagCompound = stack.func_77978_p();
                    if (tagCompound == null) {
                        return null;
                    }
                    ItemStack itemStack = new ItemStack(tagCompound.func_74775_l("bark"));
                    if (itemStack.func_190926_b()) {
                        return null;
                    }
                    ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
                    IBakedModel itemModel = mesher.func_178089_a(itemStack);
                    itemModel = itemModel.func_188617_f().handleItemState(itemModel, itemStack, world, entity);
                    return models.computeIfAbsent(itemModel.func_177554_e(), tex -> new ModelBark(originalModel, (TextureAtlasSprite)tex));
                }
            });
        }
    }

    private void registerBlockModel(@Nonnull ItemBlock item) {
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(ProxyClient.wrap(item.getRegistryName()), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)modelResourceLocation);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{modelResourceLocation});
        ModelLoader.setCustomMeshDefinition((Item)item, stack -> modelResourceLocation);
        if (Proxy.itemBlockModelHook != null) {
            Proxy.itemBlockModelHook.accept(item, modelResourceLocation);
        }
    }

    private void registerModel(@Nonnull Item item) {
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(ProxyClient.wrap(item.getRegistryName()), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)modelResourceLocation);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{modelResourceLocation});
        ModelLoader.setCustomMeshDefinition((Item)item, stack -> modelResourceLocation);
        if (Proxy.itemModelHook != null) {
            Proxy.itemModelHook.accept(modelResourceLocation);
        }
    }

    @Override
    public void init() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileFlowerPedastal.class, (TileEntitySpecialRenderer)new TESRPlantFrame());
        Minecraft.func_71410_x().getItemColors().func_186730_a(BeeMod.instance.itemIngredients::getColorFromItemstack, new Item[]{BeeMod.instance.itemIngredients});
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void run(@Nonnull ClientRunnable runnable) {
        runnable.run();
    }

    @Override
    public <R, T> R apply(ClientFunction<T, R> trClientFunction, T t) {
        return trClientFunction.applyClient(t);
    }

    public static abstract class ModelWithOverrides
    extends ModelDelegate {
        public ModelWithOverrides(IBakedModel base) {
            super(base);
        }

        @Override
        @Nonnull
        public ItemOverrideList func_188617_f() {
            return new ItemOverrideList(Lists.newArrayList()){

                @Nonnull
                public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                    IBakedModel iBakedModel = this.handleItemState(originalModel, stack, world, entity);
                    if (iBakedModel == null) {
                        return base.func_188617_f().handleItemState(originalModel, stack, world, entity);
                    }
                    return iBakedModel;
                }
            };
        }

        @Nullable
        public abstract IBakedModel handleItemState(IBakedModel var1, ItemStack var2, World var3, EntityLivingBase var4);

        @Override
        @Nonnull
        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
            return Pair.of((Object)this, null);
        }
    }

    public static class ModelBark
    extends ModelDelegate {
        final TextureAtlasSprite sprite;
        final HashMap<EnumFacing, List<BakedQuad>> transformedQuads = new HashMap();

        public ModelBark(IBakedModel base, TextureAtlasSprite sprite) {
            super(base);
            this.sprite = sprite;
        }

        @Override
        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return this.sprite;
        }

        @Override
        @Nonnull
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            ArrayList quadList = this.transformedQuads.get(side);
            if (quadList == null || BeeMod.deobf_folder) {
                List<BakedQuad> quads = super.func_188616_a(state, null, rand);
                if (quads.isEmpty()) {
                    this.transformedQuads.put(side, (List<BakedQuad>)ImmutableList.of());
                    return ImmutableList.of();
                }
                quadList = Lists.newArrayList();
                this.transformedQuads.put(side, quadList);
                HashSet texes = new HashSet();
                HashMultimap sprites = HashMultimap.create();
                for (BakedQuad quad : quads) {
                    if (quad.func_178210_d().func_176740_k() != EnumFacing.Axis.Z) {
                        quadList.add(new BakedQuadRetextured(quad, this.sprite));
                    }
                    sprites.put((Object)quad.func_178211_c(), (Object)quad.func_187508_a());
                }
                if (side == null) {
                    for (Integer tintIndex : sprites.keySet()) {
                        ArrayList q = new ArrayList();
                        for (TextureAtlasSprite tex : sprites.get((Object)tintIndex)) {
                            q.addAll(ItemTextureQuadConverter.convertTexture((VertexFormat)DefaultVertexFormats.field_176599_b, (TRSRTransformation)TRSRTransformation.identity(), (TextureAtlasSprite)tex, (TextureAtlasSprite)this.sprite, (float)0.53125f, (EnumFacing)EnumFacing.SOUTH, (int)-1));
                            q.addAll(ItemTextureQuadConverter.convertTexture((VertexFormat)DefaultVertexFormats.field_176599_b, (TRSRTransformation)TRSRTransformation.identity(), (TextureAtlasSprite)tex, (TextureAtlasSprite)this.sprite, (float)0.46875f, (EnumFacing)EnumFacing.NORTH, (int)-1));
                        }
                        if (tintIndex == 0) {
                            quadList.addAll(q);
                            continue;
                        }
                        for (BakedQuad quad : q) {
                            quadList.add(new BakedQuad(Arrays.copyOf(quad.func_178209_a(), quad.func_178209_a().length), tintIndex.intValue(), FaceBakery.func_178410_a((int[])quad.func_178209_a()), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat()));
                        }
                    }
                }
            }
            return quadList;
        }
    }
}

