/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.google.common.collect.Lists;
import com.rwtema.careerbees.effects.EffectBase;
import com.rwtema.careerbees.effects.ISpecialBeeEffect;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import com.rwtema.careerbees.helpers.ParticleHelper;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.genetics.IEffectData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EffectClockwork
extends EffectBase
implements ISpecialBeeEffect.SpecialEffectBlock {
    public static final EffectBase INSTANCE = new EffectClockwork("clockwinding");
    @Nullable
    public Class<? extends TileEntity> tile;

    public EffectClockwork(String rawname) {
        super(rawname);
        try {
            this.tile = Class.forName("forestry.energy.tiles.TileEngineClockwork");
        }
        catch (ClassNotFoundException e) {
            this.tile = null;
        }
    }

    @Override
    public void processingTick(World world, BlockPos pos, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing, EnumFacing facing) {
        if (this.tile == null) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (this.tile.isInstance(tileEntity)) {
            this.processTile(genome, world, tileEntity);
        }
    }

    @Override
    public float getCooldown(IBeeGenome genome, Random random) {
        return 200.0f;
    }

    @Override
    @Nonnull
    public IEffectData doEffectBase(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, IEffectSettingsHolder settings) {
        if (this.tile == null) {
            return storedData;
        }
        World worldObj = housing.getWorldObj();
        ArrayList tiles = Lists.newArrayList(this.getTiles(worldObj, this.tile, EffectClockwork.getAABB(genome, housing)));
        tiles.sort(Comparator.comparing(TileEntity::func_174877_v, Comparator.comparingInt(Vec3i::func_177958_n).thenComparingInt(Vec3i::func_177952_p).thenComparingInt(Vec3i::func_177956_o)));
        int n = 0;
        for (TileEntity tileEntity : tiles) {
            if (++n == 3) break;
            this.processTile(genome, worldObj, tileEntity);
        }
        return storedData;
    }

    public void processTile(@Nonnull IBeeGenome genome, @Nonnull World worldObj, @Nonnull TileEntity tileEntity) {
        NBTTagCompound nbtTagCompound = tileEntity.func_189515_b(new NBTTagCompound());
        if (nbtTagCompound.func_150297_b("Wound", 5)) {
            float min = Math.min(2.0f + genome.getSpeed() * 4.0f, 8.0f);
            if (nbtTagCompound.func_74760_g("Wound") < min / 2.0f) {
                IBlockState blockState = worldObj.func_180495_p(tileEntity.func_174877_v());
                worldObj.func_184138_a(tileEntity.func_174877_v(), blockState, blockState, 0);
            }
            if (nbtTagCompound.func_74760_g("Wound") < min) {
                nbtTagCompound.func_74776_a("Wound", min);
                tileEntity.func_145839_a(nbtTagCompound);
            }
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public IEffectData doFX(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing) {
        IBeekeepingLogic beekeepingLogic = housing.getBeekeepingLogic();
        ArrayList<BlockPos> flowerPositions = new ArrayList<BlockPos>(beekeepingLogic.getFlowerPositions());
        this.getTiles(housing.getWorldObj(), this.tile, EffectClockwork.getAABB(genome, housing)).stream().map(TileEntity::func_174877_v).forEach(flowerPositions::add);
        ParticleHelper.BEE_HIVE_FX.addBeeHiveFX(housing, genome, flowerPositions);
        return storedData;
    }

    @Override
    public boolean canHandleBlock(World world, BlockPos pos, @Nonnull IBeeGenome genome, EnumFacing sideHit) {
        return this.tile != null && this.tile.isInstance(world.func_175625_s(pos));
    }

    @Override
    public boolean handleBlock(@Nonnull World world, @Nonnull BlockPos pos, EnumFacing facing, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        if (this.tile == null) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (this.tile.isInstance(tileEntity)) {
            this.processTile(genome, world, tileEntity);
            return true;
        }
        return false;
    }
}

