/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.effects.EffectBaseThrottled;
import com.rwtema.careerbees.effects.ISpecialBeeEffect;
import com.rwtema.careerbees.effects.settings.Filter;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import com.rwtema.careerbees.effects.settings.Setting;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EffectPickup
extends EffectBaseThrottled
implements ISpecialBeeEffect.SpecialEffectEntity {
    public static final EffectPickup INSTANCE = new EffectPickup("pickup", 20.0f);
    final Filter filter = new Filter(this);
    final Setting.YesNo voidExcess = new Setting.YesNo(this, "voidExcess", false);

    public EffectPickup(String name, float baseTicksBetweenProcessing) {
        super(name, baseTicksBetweenProcessing);
    }

    @Override
    public void performEffect(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, @Nonnull Random random, @Nonnull World world, BlockPos pos, IBeeModifier beeHousingModifier, IBeeModifier beeModeModifier, @Nonnull IEffectSettingsHolder settings) {
        AxisAlignedBB aabb = EffectPickup.getAABB(genome, housing);
        Predicate<ItemStack> matcher = EffectPickup.getFilter(housing, world, settings, aabb, this.filter);
        List list = world.func_175647_a(EntityItem.class, aabb, t -> t != null && !t.field_70128_L && !t.func_92059_d().func_190926_b() && matcher.test(t.func_92059_d()));
        Collections.shuffle(list);
        Boolean value = (Boolean)this.voidExcess.getValue(settings);
        for (EntityItem entityItem : list) {
            this.grabItem(entityItem, housing, value);
        }
    }

    public void grabItem(EntityItem entityItem, @Nonnull IBeeHousing housing, boolean voidExcess) {
        ItemStack currentItem = entityItem.func_92059_d();
        ItemStack remainderAfterInsert = EffectPickup.tryAdd(currentItem, housing.getBeeInventory());
        if (voidExcess) {
            entityItem.func_70106_y();
        } else if (remainderAfterInsert != currentItem) {
            if (remainderAfterInsert.func_190926_b()) {
                entityItem.func_70106_y();
            } else {
                entityItem.func_92058_a(remainderAfterInsert);
            }
        }
    }

    @Override
    public boolean canHandleEntity(Entity livingBase, @Nonnull IBeeGenome genome) {
        return livingBase instanceof EntityItem;
    }

    @Override
    public boolean handleEntityLiving(Entity livingBase, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        if (livingBase instanceof EntityItem) {
            this.grabItem((EntityItem)livingBase, housing, false);
            return true;
        }
        return false;
    }
}

