/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.blocks.TileFlowerPedastal;
import com.rwtema.careerbees.effects.EffectItemModification;
import com.rwtema.careerbees.helpers.RandomSelector;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IMutation;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class EffectResearcher
extends EffectItemModification {
    public static final EffectResearcher INSTANCE = new EffectResearcher("study", 100.0f);

    public EffectResearcher(String name, float baseTicksBetweenProcessing) {
        super(name, baseTicksBetweenProcessing);
    }

    public EffectResearcher(String name, boolean isDominant, boolean isCombinable, float baseTicksBetweenProcessing, float chanceOfProcessing) {
        super(name, isDominant, isCombinable, baseTicksBetweenProcessing, chanceOfProcessing);
    }

    @Override
    @Nullable
    public ItemStack modifyStack(IBeeGenome genome, @Nonnull ItemStack stack, @Nullable IBeeHousing housing) {
        if (housing != null && housing.getOwner() != null) {
            EnumBeeType type = BeeManager.beeRoot.getType(stack);
            if (type == null) {
                return null;
            }
            Random rand = housing.getWorldObj().field_73012_v;
            switch (type) {
                case DRONE: {
                    if (rand.nextInt(100) != 0) {
                        return rand.nextInt(10) == 0 ? ItemStack.field_190927_a : null;
                    }
                }
                case PRINCESS: 
                case QUEEN: {
                    if (rand.nextInt(10) == 0) break;
                    return null;
                }
            }
            IBee member = BeeManager.beeRoot.getMember(stack);
            if (member != null) {
                if (rand.nextInt(4) == 0) {
                    IAlleleBeeSpecies species;
                    IAlleleBeeSpecies iAlleleBeeSpecies = species = rand.nextBoolean() ? member.getGenome().getPrimary() : member.getGenome().getSecondary();
                    if (species.isSecret()) {
                        return null;
                    }
                    int complexity = species.getComplexity();
                    if (rand.nextInt(12) < Math.min(complexity, 11)) {
                        return null;
                    }
                    return AlleleManager.alleleRegistry.getSpeciesNoteStack(housing.getOwner(), (IAlleleSpecies)species);
                }
                RandomSelector mutation = new RandomSelector(rand);
                mutation.selectAny(BeeManager.beeRoot.getCombinations((IAllele)member.getGenome().getPrimary()));
                mutation.selectAny(BeeManager.beeRoot.getCombinations((IAllele)member.getGenome().getSecondary()));
                IMutation iMutation = (IMutation)mutation.get();
                if (iMutation == null || iMutation.isSecret()) {
                    return null;
                }
                int complexity = iMutation.getAllele0().getComplexity() + iMutation.getAllele1().getComplexity();
                if (rand.nextInt(23) < Math.min(complexity, 22)) {
                    return null;
                }
                return AlleleManager.alleleRegistry.getMutationNoteStack(housing.getOwner(), iMutation);
            }
        }
        return null;
    }

    @Override
    public boolean shouldRelease(IBeeGenome genome, TileFlowerPedastal frame, ItemStack oldStack, @Nonnull ItemStack newStack, IBeeHousing housing) {
        return true;
    }

    @Override
    public boolean acceptItemStack(@Nonnull ItemStack stack) {
        IBee member = BeeManager.beeRoot.getMember(stack);
        return member != null && member.isAnalyzed();
    }
}

