/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.helpers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RandomSelector<E> {
    private final Random random;
    @Nullable
    private E value = null;
    private int n = 0;

    public RandomSelector(Random random) {
        this.random = random;
    }

    @Nonnull
    public RandomSelector<E> select(E newValue) {
        ++this.n;
        if (this.n == 1 || this.random.nextInt(this.n) == 0) {
            this.value = newValue;
        }
        return this;
    }

    @Nonnull
    public RandomSelector<E> selectAny(@Nonnull Iterable<? extends E> iterables) {
        iterables.forEach(this::select);
        return this;
    }

    @Nonnull
    public RandomSelector<E> selectAny(@Nonnull Collection<? extends E> collection) {
        int s = collection.size();
        if (s == 0) {
            return this;
        }
        int k = this.random.nextInt(s + this.n);
        this.n += s;
        if (k < s) {
            Iterator<E> iterator = collection.iterator();
            for (int i = 0; iterator.hasNext() && i <= k; ++i) {
                this.value = iterator.next();
            }
            return this;
        }
        return this;
    }

    @Nonnull
    public RandomSelector<E> selectAny(@Nonnull List<? extends E> list) {
        int s = list.size();
        if (s == 0) {
            return this;
        }
        int k = this.random.nextInt(s + this.n);
        this.n += s;
        if (k < s) {
            this.value = list.get(k);
        }
        return this;
    }

    @Nullable
    public E get() {
        return this.value;
    }

    public Optional<E> getOptional() {
        if (this.n == 0) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.value);
    }
}

