/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.dimension;

import ipsis.Woot;
import ipsis.woot.command.ITextStatus;
import ipsis.woot.configuration.EnumConfigKey;
import ipsis.woot.dimension.world.WootWorldProvider;
import ipsis.woot.handler.ConfigHandler;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.util.DebugSetup;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;

public class WootDimensionManager
implements ITextStatus {
    private static int dimensionId = -1;
    private static DimensionType dimensionType;
    private boolean touched = false;
    public static final int CHUNK_X = 0;
    public static final int CHUNK_Z = 0;

    public void init() {
        dimensionId = Woot.wootConfiguration.getInteger(EnumConfigKey.TARTARUS_ID);
        if (dimensionId == -1) {
            dimensionId = DimensionManager.getNextFreeDimId();
            ConfigHandler.saveDimensionId(dimensionId);
        }
        dimensionType = DimensionType.register((String)"tartarus", (String)"_lootlearn", (int)dimensionId, WootWorldProvider.class, (boolean)false);
        DimensionManager.registerDimension((int)dimensionId, (DimensionType)dimensionType);
    }

    public DimensionType getDimensionType() {
        return dimensionType;
    }

    public int getDimensionId() {
        return dimensionId;
    }

    @Nullable
    public WorldServer getWorldServer(World world) {
        return world.func_73046_m().func_71218_a(dimensionId);
    }

    private boolean hasChunkGenerated(WorldServer worldServer) {
        return worldServer != null && worldServer.func_190526_b(0, 0);
    }

    private boolean isChunkLoaded(WorldServer worldServer) {
        return worldServer != null && worldServer.func_175667_e(new BlockPos(0, 0, 0));
    }

    public void touchSpawnChunk(World world) {
        if (!this.touched) {
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.TARTARUS, "touchSpawnChunk", "Generating chunks");
            WorldServer worldServer = world.func_73046_m().func_71218_a(dimensionId);
            ChunkProviderServer chunkProviderServer = worldServer.func_72863_F();
            if (!chunkProviderServer.func_73149_a(0, 0)) {
                try {
                    chunkProviderServer.func_186025_d(0, 0);
                    chunkProviderServer.field_186029_c.func_185931_b(0, 0);
                }
                catch (Exception e) {
                    LogHelper.error("WootDimensionManager failed to create dimension");
                }
            }
            this.touched = true;
        }
    }

    @Override
    public List<String> getStatus() {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getStatus(WorldServer worldServer) {
        ArrayList<String> status = new ArrayList<String>();
        status.add("Dimension Id: " + this.getDimensionId());
        status.add("Chunk Generated: " + this.hasChunkGenerated(worldServer));
        status.add("Chunk loaded: " + this.isChunkLoaded(worldServer));
        return status;
    }
}

