/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.farming;

import ipsis.woot.farming.ITickTracker;
import net.minecraft.world.World;

public class SimpleTickTracker
implements ITickTracker {
    private long lastWorldTime = -1L;
    private int structureTicksTimeout = 0;
    private int learnTicksTimeout = 0;
    private int currStructureTicks = 0;
    private int currLearnTicks = 0;

    @Override
    public void tick(World world) {
        long currWorldTime = world.func_82737_E();
        if (this.lastWorldTime != currWorldTime) {
            this.lastWorldTime = currWorldTime;
            if (this.structureTicksTimeout > 0) {
                ++this.currStructureTicks;
            }
            if (this.learnTicksTimeout > 0) {
                ++this.currLearnTicks;
            }
        }
    }

    @Override
    public boolean hasLearnTickExpired() {
        return this.learnTicksTimeout > 0 && this.currLearnTicks >= this.learnTicksTimeout;
    }

    @Override
    public boolean hasStructureTickExpired() {
        return this.structureTicksTimeout > 0 && this.currStructureTicks >= this.structureTicksTimeout;
    }

    @Override
    public void setLearnTickCount(int ticks) {
        this.learnTicksTimeout = ticks;
    }

    @Override
    public void setStructureTickCount(int ticks) {
        this.structureTicksTimeout = ticks;
    }

    @Override
    public void resetLearnTickCount() {
        this.currLearnTicks = 0;
    }

    @Override
    public void resetStructureTickCount() {
        this.currStructureTicks = 0;
    }
}

