/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.farmstructure;

import ipsis.Woot;
import ipsis.woot.multiblock.EnumMobFactoryTier;
import ipsis.woot.util.WootMob;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ScannedFarmController {
    private BlockPos pos;
    WootMob wootMob;

    public static boolean isEqual(ScannedFarmController a, ScannedFarmController b) {
        if (a == null || b == null) {
            return false;
        }
        if (!a.pos.equals((Object)b.pos)) {
            return false;
        }
        return a.wootMob.getWootMobName().equals(b.wootMob.getWootMobName());
    }

    public boolean isValid() {
        return this.isPresent() && this.isValidMob();
    }

    public boolean isPresent() {
        return this.pos != null && this.wootMob != null;
    }

    private boolean isValidMob() {
        if (this.wootMob == null) {
            return false;
        }
        if (!EntityList.func_180125_b((ResourceLocation)this.wootMob.getWootMobName().getResourceLocation())) {
            return false;
        }
        return Woot.policyRepository.canGenerateFrom(this.wootMob.getWootMobName());
    }

    public boolean canGenerateFrom() {
        return this.wootMob != null && Woot.policyRepository.canGenerateFrom(this.wootMob.getWootMobName());
    }

    public boolean isTierValid(World world, EnumMobFactoryTier tier) {
        if (this.wootMob == null) {
            return false;
        }
        EnumMobFactoryTier mobTier = Woot.wootConfiguration.getFactoryTier(world, this.wootMob.getWootMobName());
        return EnumMobFactoryTier.isLessThanOrEqual(mobTier, tier);
    }

    public BlockPos getBlocks() {
        return this.pos;
    }

    public void setBlocks(BlockPos pos) {
        this.pos = pos;
    }
}

