/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.item;

import ipsis.Woot;
import ipsis.woot.block.BlockMobFactoryHeart;
import ipsis.woot.block.BlockMobFactoryStructure;
import ipsis.woot.init.ModBlocks;
import ipsis.woot.init.ModItems;
import ipsis.woot.item.ItemWoot;
import ipsis.woot.multiblock.EnumMobFactoryModule;
import ipsis.woot.multiblock.EnumMobFactoryTier;
import ipsis.woot.multiblock.MobFactoryModule;
import ipsis.woot.oss.ItemHelper;
import ipsis.woot.oss.client.ModelHelper;
import ipsis.woot.util.BlockPosHelper;
import ipsis.woot.util.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBuilder
extends ItemWoot {
    public static final String BASENAME = "builder";
    private static String TIER_TAG = "tier";

    public ItemBuilder() {
        super(BASENAME);
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelHelper.registerItem(ModItems.itemBuilder, BASENAME.toLowerCase());
    }

    private EnumMobFactoryTier getTierFromNbt(ItemStack itemStack) {
        NBTTagCompound tag;
        if (!itemStack.func_77942_o()) {
            tag = new NBTTagCompound();
            tag.func_74768_a(TIER_TAG, EnumMobFactoryTier.TIER_ONE.ordinal());
            itemStack.func_77982_d(tag);
        }
        tag = itemStack.func_77978_p();
        return EnumMobFactoryTier.getTier(tag.func_74762_e(TIER_TAG));
    }

    private void cycleTier(ItemStack itemStack, EntityPlayer entityPlayer) {
        NBTTagCompound tag;
        if (!itemStack.func_77942_o()) {
            tag = new NBTTagCompound();
            tag.func_74768_a(TIER_TAG, EnumMobFactoryTier.TIER_ONE.ordinal());
            itemStack.func_77982_d(tag);
        }
        tag = itemStack.func_77978_p();
        EnumMobFactoryTier next = EnumMobFactoryTier.getTier(tag.func_74762_e(TIER_TAG));
        next = next.getNext();
        tag.func_74768_a(TIER_TAG, next.ordinal());
        entityPlayer.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localize(next.getTranslated("info.woot.tier"))), false);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.ITALIC + "Builds the factory for you");
        tooltip.add(TextFormatting.ITALIC + StringHelper.localize("info.woot.intern.0"));
        tooltip.add("" + TextFormatting.RED + TextFormatting.ITALIC + StringHelper.localize("info.woot.intern.1"));
        EnumMobFactoryTier tier = this.getTierFromNbt(stack);
        tooltip.add(TextFormatting.BLUE + StringHelper.localize(tier.getTranslated("info.woot.tier")));
        for (EnumMobFactoryModule m : EnumMobFactoryModule.values()) {
            int c = Woot.factoryPatternRepository.getBlockCount(tier, m);
            if (c <= 0) continue;
            tooltip.add("" + TextFormatting.GREEN + c + " " + StringHelper.localize("tile.woot.structure." + m.func_176610_l() + ".name"));
        }
        tooltip.add("" + TextFormatting.RED + TextFormatting.ITALIC + "1 " + StringHelper.localize("tile.woot.factory.name"));
        tooltip.add("" + TextFormatting.RED + TextFormatting.ITALIC + "1 " + StringHelper.localize("tile.woot.controller.name"));
        tooltip.add("" + TextFormatting.RED + TextFormatting.ITALIC + "1 " + StringHelper.localize("tile.woot.importer.name"));
        tooltip.add("" + TextFormatting.RED + TextFormatting.ITALIC + "1 " + StringHelper.localize("tile.woot.exporter.name"));
        tooltip.add("" + TextFormatting.RED + TextFormatting.ITALIC + "1 Basic/Advanced/Premium power cell");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemStack = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af()) {
            RayTraceResult rayTraceResult = this.func_77621_a(worldIn, playerIn, false);
            if (rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
            }
            if (!worldIn.field_72995_K) {
                this.cycleTier(itemStack, playerIn);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumFacing factoryFacing;
        Block b;
        EnumActionResult result = EnumActionResult.PASS;
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.func_70093_af() && (b = worldIn.func_180495_p(pos).func_177230_c()) instanceof BlockMobFactoryHeart && this.tryBuild(player, worldIn, pos, factoryFacing = (EnumFacing)worldIn.func_180495_p(pos).func_177229_b((IProperty)BlockMobFactoryHeart.FACING), this.getTierFromNbt(itemStack))) {
            result = EnumActionResult.SUCCESS;
        }
        return result;
    }

    private boolean playerHasBlock(EntityPlayer player, EnumMobFactoryModule m) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack itemStack = ((BlockMobFactoryStructure)ModBlocks.blockStructure).getItemStack(m);
        for (ItemStack playerItemStack : player.field_71071_by.field_70462_a) {
            if (playerItemStack.func_190926_b() || !ItemHelper.itemsEqualWithMetadata(itemStack, playerItemStack)) continue;
            return true;
        }
        return false;
    }

    private void takePlayerBlock(EntityPlayer player, EnumMobFactoryModule m) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        ItemStack itemStack = ((BlockMobFactoryStructure)ModBlocks.blockStructure).getItemStack(m);
        for (ItemStack playerItemStack : player.field_71071_by.field_70462_a) {
            if (playerItemStack.func_190926_b() || !ItemHelper.itemsEqualWithMetadata(itemStack, playerItemStack)) continue;
            playerItemStack.func_190918_g(1);
            return;
        }
    }

    private boolean isBlockCorrect(Block block, IBlockState iBlockState, EnumMobFactoryModule m) {
        if (!(block instanceof BlockMobFactoryStructure)) {
            return false;
        }
        BlockMobFactoryStructure s = (BlockMobFactoryStructure)block;
        return s.getModuleTypeFromState(iBlockState) == m;
    }

    private boolean tryBuild(EntityPlayer player, World world, BlockPos pos, EnumFacing facing, EnumMobFactoryTier tier) {
        for (MobFactoryModule m : Woot.factoryPatternRepository.getAllModules(tier)) {
            BlockPos placePos = new BlockPos((Vec3i)pos).func_177971_a((Vec3i)BlockPosHelper.rotateFromSouth(m.getOffset(), facing.func_176734_d()));
            IBlockState currState = world.func_180495_p(placePos);
            Block currBlock = currState.func_177230_c();
            if (this.isBlockCorrect(currBlock, currState, m.getModuleType())) continue;
            if (!this.playerHasBlock(player, m.getModuleType())) {
                player.func_146105_b((ITextComponent)new TextComponentString("Block not in inventory (" + StringHelper.localize("tile.woot.structure." + m.getModuleType().func_176610_l() + ".name") + ")"), false);
                return false;
            }
            if (currBlock.isAir(currState, (IBlockAccess)world, placePos) || currBlock.func_176200_f((IBlockAccess)world, placePos)) {
                int meta = m.getModuleType().getMetadata();
                world.func_175656_a(placePos, ModBlocks.blockStructure.func_176203_a(meta));
                this.takePlayerBlock(player, m.getModuleType());
                return true;
            }
            player.func_146105_b((ITextComponent)new TextComponentString("Cannot replace block at " + placePos), false);
            return false;
        }
        return false;
    }
}

