/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.loot;

import ipsis.woot.loot.ILootGeneration;
import ipsis.woot.loot.LootGenerationFarmInfo;
import ipsis.woot.loot.generators.BloodMagicLifeEssenceGenerator;
import ipsis.woot.loot.generators.BloodMagicWillGenerator;
import ipsis.woot.loot.generators.DecapitationGenerator;
import ipsis.woot.loot.generators.EvilCraftBloodGenerator;
import ipsis.woot.loot.generators.ILootGenerator;
import ipsis.woot.loot.generators.ItemGenerator;
import ipsis.woot.loot.generators.TierShardGenerator;
import ipsis.woot.loot.generators.XpGenerator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class LootGeneration
implements ILootGeneration {
    List<ILootGenerator> generatorList = new LinkedList<ILootGenerator>();

    @Override
    public void initialise() {
        this.generatorList.add(new ItemGenerator());
        this.generatorList.add(new XpGenerator());
        this.generatorList.add(new DecapitationGenerator());
        this.generatorList.add(new TierShardGenerator());
        if (Loader.isModLoaded((String)"bloodmagic")) {
            this.generatorList.add(new BloodMagicLifeEssenceGenerator());
            this.generatorList.add(new BloodMagicWillGenerator());
        }
        if (Loader.isModLoaded((String)"evilcraft")) {
            this.generatorList.add(new EvilCraftBloodGenerator());
        }
    }

    @Override
    public void generate(World world, LootGenerationFarmInfo farmInfo) {
        for (ILootGenerator lootGenerator : this.generatorList) {
            lootGenerator.generate(world, farmInfo);
        }
    }
}

