/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.oss;

import ipsis.woot.reference.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    public static String copyConfigFileFromJar(String filename, boolean replaceIfExists) throws IOException {
        if (replaceIfExists || !FileUtils.getConfigFile(filename).exists()) {
            IOUtils.copy((InputStream)FileUtils.class.getResourceAsStream(FileUtils.getConfigResourcePath(filename)), (OutputStream)new FileOutputStream(FileUtils.getConfigFile(filename)));
        }
        return IOUtils.toString((Reader)new FileReader(FileUtils.getConfigFile(filename)));
    }

    public static String getFileFromJar(String filename) throws IOException {
        return IOUtils.toString((InputStream)FileUtils.class.getResourceAsStream(FileUtils.getTextResourcePath(filename)), (Charset)StandardCharsets.UTF_8);
    }

    private static String getConfigResourcePath(String filename) {
        return "/assets/woot/config/" + filename;
    }

    private static String getTextResourcePath(String filename) {
        return "/assets/woot/text/" + filename;
    }

    public static File getConfigFile(String filename) {
        return new File(Files.getConfigDirectory(), filename);
    }
}

