/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class SerializationHelper {
    public static String readJsonFile(File file) throws FileNotFoundException {
        StringBuilder sb = new StringBuilder();
        if (file != null) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) {
                    throw (FileNotFoundException)e;
                }
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static void writeJsonFile(File file, String data) {
        if (file == null) {
            return;
        }
        file.getParentFile().mkdirs();
        File tmpFile = new File(file.getAbsolutePath() + "_tmp");
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(tmpFile));){
            writer.write(data);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (file.exists()) {
            file.delete();
        }
        if (!file.exists()) {
            tmpFile.renameTo(file);
        }
    }
}

