/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbguides.gui.components;

import com.feed_the_beast.ftbguides.client.FTBGuidesClientConfig;
import com.feed_the_beast.ftbguides.gui.components.ComponentPanel;
import com.feed_the_beast.ftbguides.gui.components.GuideComponent;
import com.feed_the_beast.ftbguides.gui.components.IGuideComponentWidget;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class TextGuideComponent
extends GuideComponent {
    public final String text;

    public TextGuideComponent(String txt) {
        this.text = txt;
    }

    @Override
    public String toString() {
        return this.text;
    }

    @Override
    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    @Override
    public IGuideComponentWidget createWidget(ComponentPanel parent) {
        return new TextWidget(parent, this);
    }

    private static class TextWidget
    extends Widget
    implements IGuideComponentWidget {
        public final TextGuideComponent component;
        public final double scale;
        public final String[] text;
        public final boolean bold;
        public final boolean italic;
        public final boolean underlined;
        public final boolean striketrough;
        public final boolean code;
        public final Icon icon;

        public TextWidget(ComponentPanel parent, TextGuideComponent t) {
            super((Panel)parent);
            this.component = t;
            this.scale = MathHelper.func_151237_a((double)Double.parseDouble(this.component.getProperty("text_scale", true, "1")), (double)0.25, (double)4.0);
            ArrayList strings = new ArrayList();
            Theme theme = this.getGui().getTheme();
            for (String s : t.text.split("\n")) {
                strings.addAll(theme.listFormattedStringToWidth(s, (int)((double)parent.maxWidth / this.scale)));
            }
            this.text = strings.isEmpty() ? StringUtils.EMPTY_ARRAY : strings.toArray(new String[0]);
            this.bold = this.component.getProperty("bold", true).equals("true");
            this.italic = this.component.getProperty("italic", true).equals("true");
            this.underlined = this.component.getProperty("underlined", true).equals("true");
            this.striketrough = this.component.getProperty("striketrough", true).equals("true");
            this.code = this.component.getProperty("code", true).equals("true");
            this.icon = Icon.getIcon((String)this.component.getProperty("icon", false));
            this.setWidth(0);
            for (int i = 0; i < this.text.length; ++i) {
                if (this.bold) {
                    this.text[i] = TextFormatting.BOLD + this.text[i];
                }
                if (this.italic) {
                    this.text[i] = TextFormatting.ITALIC + this.text[i];
                }
                if (this.underlined) {
                    this.text[i] = TextFormatting.UNDERLINE + this.text[i];
                }
                if (this.striketrough) {
                    this.text[i] = TextFormatting.STRIKETHROUGH + this.text[i];
                }
                if (this.code) {
                    this.setWidth(Math.max(this.width, (int)((double)(this.text[i].length() * (FTBGuidesClientConfig.general.use_unicode_font ? 4 : 6)) * this.scale)));
                    continue;
                }
                this.setWidth(Math.max(this.width, (int)((double)theme.getStringWidth(this.text[i]) * this.scale)));
            }
            int h1 = (int)(((double)theme.getFontHeight() + 1.0) * this.scale);
            this.setHeight(this.text.length == 0 ? h1 : h1 * this.text.length);
            if (!this.icon.isEmpty()) {
                this.setWidth(this.width + 10);
            }
        }

        public void addMouseOverText(List<String> list) {
            String s = this.component.getProperty("hover", false);
            if (!s.isEmpty()) {
                list.add(s);
            }
        }

        public boolean mousePressed(MouseButton button) {
            String s;
            if (this.isMouseOver() && !(s = this.component.getProperty("click", true)).isEmpty() && this.handleClick(s)) {
                GuiHelper.playClickSound();
                return true;
            }
            return false;
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            boolean mouseOver;
            boolean bl = mouseOver = this.isMouseOver() && (!this.component.getProperty("click", true).isEmpty() || !this.component.getProperty("hover", false).isEmpty());
            if (!this.icon.isEmpty()) {
                this.icon.draw(x, y, 8, 8);
                x += 10;
            }
            int h1 = theme.getFontHeight() + 1;
            if (this.scale != 1.0) {
                GuiHelper.setFixUnicode((boolean)false);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            GlStateManager.func_179139_a((double)this.scale, (double)this.scale, (double)1.0);
            Color4I color = theme.getContentColor(mouseOver || this.code ? WidgetType.MOUSE_OVER : WidgetType.NORMAL);
            for (int i = 0; i < this.text.length; ++i) {
                if (this.code) {
                    for (int ci = 0; ci < this.text[i].length(); ++ci) {
                        theme.drawString(Character.toString(this.text[i].charAt(ci)), ci * (FTBGuidesClientConfig.general.use_unicode_font ? 4 : 6), h1 * i, color, 0);
                    }
                    continue;
                }
                theme.drawString(this.text[i], 0, h1 * i, color, 0);
            }
            GlStateManager.func_179121_F();
            if (this.scale != 1.0) {
                GuiHelper.setFixUnicode((boolean)this.getGui().fixUnicode);
            }
        }
    }
}

