/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.config;

import greymerk.roguelike.config.ConfigFile;
import greymerk.roguelike.config.INIParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Tuple;

public enum RogueConfig {
    DONATURALSPAWN,
    SPAWNFREQUENCY,
    GENEROUS,
    MOBDROPS,
    DIMENSIONWL,
    DIMENSIONBL,
    PRECIOUSBLOCKS,
    LOOTING,
    UPPERLIMIT,
    LOWERLIMIT,
    ROGUESPAWNERS,
    ENCASE,
    FURNITURE,
    RANDOM,
    SPAWNBUILTIN,
    SPAWNCHANCE;

    public static final String configDirName = "config/roguelike_dungeons";
    public static final String configFileName = "roguelike.cfg";
    public static boolean testing;
    private static ConfigFile instance;

    public static String getName(RogueConfig option) {
        switch (option) {
            case DONATURALSPAWN: {
                return "doNaturalSpawn";
            }
            case SPAWNFREQUENCY: {
                return "spawnFrequency";
            }
            case SPAWNCHANCE: {
                return "spawnChance";
            }
            case GENEROUS: {
                return "generous";
            }
            case DIMENSIONWL: {
                return "dimensionWL";
            }
            case DIMENSIONBL: {
                return "dimensionBL";
            }
            case PRECIOUSBLOCKS: {
                return "preciousBlocks";
            }
            case LOOTING: {
                return "looting";
            }
            case UPPERLIMIT: {
                return "upperLimit";
            }
            case LOWERLIMIT: {
                return "lowerLimit";
            }
            case ROGUESPAWNERS: {
                return "rogueSpawners";
            }
            case ENCASE: {
                return "encase";
            }
            case FURNITURE: {
                return "furniture";
            }
            case RANDOM: {
                return "random";
            }
            case SPAWNBUILTIN: {
                return "doBuiltinSpawn";
            }
        }
        return null;
    }

    public static Tuple<String, ?> getDefault(RogueConfig option) {
        switch (option) {
            case DONATURALSPAWN: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)true);
            }
            case SPAWNCHANCE: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)1.0);
            }
            case SPAWNFREQUENCY: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)10);
            }
            case GENEROUS: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)true);
            }
            case DIMENSIONWL: {
                ArrayList<Integer> bl = new ArrayList<Integer>();
                bl.add(0);
                return new Tuple((Object)RogueConfig.getName(option), bl);
            }
            case DIMENSIONBL: {
                return new Tuple((Object)RogueConfig.getName(option), new ArrayList());
            }
            case PRECIOUSBLOCKS: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)true);
            }
            case LOOTING: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)0.085);
            }
            case UPPERLIMIT: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)100);
            }
            case LOWERLIMIT: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)60);
            }
            case ROGUESPAWNERS: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)true);
            }
            case ENCASE: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)false);
            }
            case FURNITURE: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)true);
            }
            case RANDOM: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)false);
            }
            case SPAWNBUILTIN: {
                return new Tuple((Object)RogueConfig.getName(option), (Object)true);
            }
        }
        return null;
    }

    private static void setDefaults() {
        if (!instance.ContainsKey(RogueConfig.getName(DONATURALSPAWN))) {
            RogueConfig.setBoolean(DONATURALSPAWN, (Boolean)RogueConfig.getDefault(DONATURALSPAWN).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(SPAWNFREQUENCY))) {
            RogueConfig.setInt(SPAWNFREQUENCY, (Integer)RogueConfig.getDefault(SPAWNFREQUENCY).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(SPAWNCHANCE))) {
            RogueConfig.setDouble(SPAWNCHANCE, (Double)RogueConfig.getDefault(SPAWNCHANCE).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(GENEROUS))) {
            RogueConfig.setBoolean(GENEROUS, (Boolean)RogueConfig.getDefault(GENEROUS).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(DIMENSIONWL))) {
            RogueConfig.setIntList(DIMENSIONWL, (List)RogueConfig.getDefault(DIMENSIONWL).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(DIMENSIONBL))) {
            RogueConfig.setIntList(DIMENSIONBL, (List)RogueConfig.getDefault(DIMENSIONBL).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(PRECIOUSBLOCKS))) {
            RogueConfig.setBoolean(PRECIOUSBLOCKS, (Boolean)RogueConfig.getDefault(PRECIOUSBLOCKS).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(LOOTING))) {
            RogueConfig.setDouble(LOOTING, (Double)RogueConfig.getDefault(LOOTING).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(UPPERLIMIT))) {
            RogueConfig.setInt(UPPERLIMIT, (Integer)RogueConfig.getDefault(UPPERLIMIT).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(LOWERLIMIT))) {
            RogueConfig.setInt(LOWERLIMIT, (Integer)RogueConfig.getDefault(LOWERLIMIT).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(ROGUESPAWNERS))) {
            RogueConfig.setBoolean(ROGUESPAWNERS, (Boolean)RogueConfig.getDefault(ROGUESPAWNERS).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(ENCASE))) {
            RogueConfig.setBoolean(ENCASE, (Boolean)RogueConfig.getDefault(ENCASE).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(FURNITURE))) {
            RogueConfig.setBoolean(FURNITURE, (Boolean)RogueConfig.getDefault(FURNITURE).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(RANDOM))) {
            RogueConfig.setBoolean(RANDOM, (Boolean)RogueConfig.getDefault(RANDOM).func_76340_b());
        }
        if (!instance.ContainsKey(RogueConfig.getName(SPAWNBUILTIN))) {
            RogueConfig.setBoolean(SPAWNBUILTIN, (Boolean)RogueConfig.getDefault(SPAWNBUILTIN).func_76340_b());
        }
    }

    public static double getDouble(RogueConfig option) {
        if (testing) {
            return (Double)RogueConfig.getDefault(option).func_76340_b();
        }
        RogueConfig.reload(false);
        Tuple<String, ?> def = RogueConfig.getDefault(option);
        return instance.GetDouble(RogueConfig.getName(option), (Double)def.func_76340_b());
    }

    public static void setDouble(RogueConfig option, double value) {
        RogueConfig.reload(false);
        instance.Set(RogueConfig.getName(option), value);
    }

    public static boolean getBoolean(RogueConfig option) {
        if (testing) {
            return (Boolean)RogueConfig.getDefault(option).func_76340_b();
        }
        RogueConfig.reload(false);
        Tuple<String, ?> def = RogueConfig.getDefault(option);
        return instance.GetBoolean(RogueConfig.getName(option), (Boolean)def.func_76340_b());
    }

    public static void setBoolean(RogueConfig option, Boolean value) {
        RogueConfig.reload(false);
        instance.Set(RogueConfig.getName(option), value);
    }

    public static int getInt(RogueConfig option) {
        if (testing) {
            return (Integer)RogueConfig.getDefault(option).func_76340_b();
        }
        RogueConfig.reload(false);
        Tuple<String, ?> def = RogueConfig.getDefault(option);
        return instance.GetInteger((String)def.func_76341_a(), (Integer)def.func_76340_b());
    }

    public static void setInt(RogueConfig option, int value) {
        RogueConfig.reload(false);
        Tuple<String, ?> def = RogueConfig.getDefault(option);
        instance.Set((String)def.func_76341_a(), value);
    }

    public static List<Integer> getIntList(RogueConfig option) {
        if (testing) {
            return (ArrayList)RogueConfig.getDefault(option).func_76340_b();
        }
        RogueConfig.reload(false);
        Tuple<String, ?> def = RogueConfig.getDefault(option);
        return instance.GetListInteger((String)def.func_76341_a(), (ArrayList)def.func_76340_b());
    }

    public static void setIntList(RogueConfig option, List<Integer> value) {
        RogueConfig.reload(false);
        Tuple<String, ?> def = RogueConfig.getDefault(option);
        instance.Set((String)def.func_76341_a(), value);
    }

    private static void init() {
        File cfile;
        if (testing) {
            return;
        }
        File configDir = new File(configDirName);
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        if (!(cfile = new File("config/roguelike_dungeons/roguelike.cfg")).exists()) {
            try {
                cfile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            instance = new ConfigFile("config/roguelike_dungeons/roguelike.cfg", new INIParser());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RogueConfig.setDefaults();
        try {
            instance.Write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reload(boolean force) {
        if (instance == null || force) {
            RogueConfig.init();
        }
    }

    static {
        testing = false;
        instance = null;
    }
}

