/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.blocks;

import greymerk.roguelike.worldgen.MetaBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockWoodSlab;
import net.minecraft.init.Blocks;

public enum Slab {
    STONE,
    STONEBRICK,
    COBBLE,
    BRICK,
    NETHERBRICK,
    QUARTZ,
    LEGACY_OAK,
    SANDSTONE,
    SANDSTONE_RED,
    OAK,
    SPRUCE,
    BIRCH,
    JUNGLE,
    ACACIA,
    DARKOAK;


    public static MetaBlock get(Slab type, boolean upsideDown, boolean full, boolean seamless) {
        MetaBlock slab = new MetaBlock(Slab.getBaseSlab(type, full));
        switch (type) {
            case STONE: {
                slab.func_177226_a(BlockStoneSlab.field_176556_M, BlockStoneSlab.EnumType.STONE);
                break;
            }
            case SANDSTONE: {
                slab.func_177226_a(BlockStoneSlab.field_176556_M, BlockStoneSlab.EnumType.SAND);
                break;
            }
            case LEGACY_OAK: {
                slab.func_177226_a(BlockStoneSlab.field_176556_M, BlockStoneSlab.EnumType.WOOD);
                break;
            }
            case COBBLE: {
                slab.func_177226_a(BlockStoneSlab.field_176556_M, BlockStoneSlab.EnumType.COBBLESTONE);
                break;
            }
            case BRICK: {
                slab.func_177226_a(BlockStoneSlab.field_176556_M, BlockStoneSlab.EnumType.BRICK);
                break;
            }
            case STONEBRICK: {
                slab.func_177226_a(BlockStoneSlab.field_176556_M, BlockStoneSlab.EnumType.SMOOTHBRICK);
                break;
            }
            case NETHERBRICK: {
                slab.func_177226_a(BlockStoneSlab.field_176556_M, BlockStoneSlab.EnumType.NETHERBRICK);
                break;
            }
            case QUARTZ: {
                slab.func_177226_a(BlockStoneSlab.field_176556_M, BlockStoneSlab.EnumType.QUARTZ);
                break;
            }
            case SANDSTONE_RED: {
                break;
            }
            case OAK: {
                slab.func_177226_a(BlockWoodSlab.field_176557_b, BlockPlanks.EnumType.OAK);
                break;
            }
            case SPRUCE: {
                slab.func_177226_a(BlockWoodSlab.field_176557_b, BlockPlanks.EnumType.SPRUCE);
                break;
            }
            case BIRCH: {
                slab.func_177226_a(BlockWoodSlab.field_176557_b, BlockPlanks.EnumType.BIRCH);
                break;
            }
            case JUNGLE: {
                slab.func_177226_a(BlockWoodSlab.field_176557_b, BlockPlanks.EnumType.JUNGLE);
                break;
            }
            case ACACIA: {
                slab.func_177226_a(BlockWoodSlab.field_176557_b, BlockPlanks.EnumType.ACACIA);
                break;
            }
            case DARKOAK: {
                slab.func_177226_a(BlockWoodSlab.field_176557_b, BlockPlanks.EnumType.DARK_OAK);
                break;
            }
        }
        if (!full && upsideDown) {
            slab.func_177226_a(BlockWoodSlab.field_176554_a, BlockSlab.EnumBlockHalf.TOP);
        }
        if (full && seamless) {
            slab.func_177226_a(BlockStoneSlab.field_176555_b, true);
        }
        return slab;
    }

    public static MetaBlock get(Slab type) {
        return Slab.get(type, false, false, false);
    }

    public static Block getBaseSlab(Slab type, boolean full) {
        switch (type) {
            case STONE: 
            case SANDSTONE: 
            case LEGACY_OAK: 
            case COBBLE: 
            case BRICK: 
            case STONEBRICK: 
            case NETHERBRICK: 
            case QUARTZ: {
                return full ? Blocks.field_150334_T : Blocks.field_150333_U;
            }
            case SANDSTONE_RED: {
                return full ? Blocks.field_180388_cO : Blocks.field_180389_cP;
            }
            case OAK: 
            case SPRUCE: 
            case BIRCH: 
            case JUNGLE: 
            case ACACIA: 
            case DARKOAK: {
                return full ? Blocks.field_150373_bw : Blocks.field_150376_bx;
            }
        }
        return Blocks.field_150333_U;
    }
}

