/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.spawners;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.spawners.Spawnable;
import greymerk.roguelike.worldgen.spawners.Spawner;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class SpawnerSettings {
    private Map<Spawner, WeightedRandomizer<Spawnable>> spawners;

    public SpawnerSettings() {
        this.spawners = new HashMap<Spawner, WeightedRandomizer<Spawnable>>();
    }

    @Deprecated
    public SpawnerSettings(JsonObject data) throws Exception {
        throw new Exception("Not implemented");
    }

    public SpawnerSettings(SpawnerSettings toCopy) {
        this();
        for (Spawner type : toCopy.spawners.keySet()) {
            if (this.spawners.get((Object)type) == null) {
                this.spawners.put(type, new WeightedRandomizer());
            }
            this.spawners.get((Object)type).merge(toCopy.spawners.get((Object)type));
        }
    }

    public SpawnerSettings(SpawnerSettings base, SpawnerSettings other) {
        this();
        for (Spawner type : base.spawners.keySet()) {
            if (this.spawners.get((Object)type) == null) {
                this.spawners.put(type, new WeightedRandomizer());
            }
            this.spawners.get((Object)type).merge(base.spawners.get((Object)type));
        }
        for (Spawner type : other.spawners.keySet()) {
            if (this.spawners.get((Object)type) == null) {
                this.spawners.put(type, new WeightedRandomizer());
            }
            this.spawners.get((Object)type).merge(other.spawners.get((Object)type));
        }
    }

    public void add(JsonObject entry) throws Exception {
        int weight;
        if (!entry.has("type")) {
            throw new Exception("Spawners entry missing type");
        }
        String typeName = entry.get("type").getAsString().toUpperCase();
        Spawner type = Spawner.valueOf(typeName);
        if (type == null) {
            throw new Exception("no such Spawner type: " + entry.get("type").getAsString());
        }
        JsonElement potentials = entry.get("potentials");
        Spawnable spawn = new Spawnable(potentials);
        int n = weight = entry.has("weight") ? entry.get("weight").getAsInt() : 1;
        if (!this.spawners.containsKey((Object)type)) {
            this.spawners.put(type, new WeightedRandomizer());
        }
        WeightedChoice<Spawnable> toAdd = new WeightedChoice<Spawnable>(spawn, weight);
        this.spawners.get((Object)type).add(toAdd);
    }

    public void generate(IWorldEditor editor, Random rand, Coord cursor, Spawner type, int level) {
        Spawnable toSpawn = this.spawners.containsKey((Object)type) ? this.spawners.get((Object)type).get(rand) : new Spawnable(type);
        toSpawn.generate(editor, rand, cursor, level);
    }

    public String toString() {
        return this.spawners.keySet().toString();
    }
}

