/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world;

import mcjty.lostcities.config.BiomeSelectionStrategy;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.LostWorldFilteredBiomeProvider;
import mcjty.lostcities.dimensions.world.WorldTypeTools;
import mcjty.lostcities.gui.GuiLostCityConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LostWorldTypeBOP
extends WorldType {
    private BiomeProvider biomeProvider = null;

    public LostWorldTypeBOP() {
        super("lostcities_bop");
    }

    public IChunkGenerator getChunkGenerator(World world, String generatorOptions) {
        return new LostCityChunkGenerator(world, world.func_72905_C());
    }

    public double getHorizon(World world) {
        LostCityProfile profile = WorldTypeTools.getProfile(world);
        if (profile.HORIZON < 0.0f) {
            return super.getHorizon(world);
        }
        return profile.HORIZON;
    }

    private BiomeProvider getInternalBiomeProvider(World world) {
        if (this.biomeProvider == null) {
            for (WorldType type : WorldType.field_77139_a) {
                if (!"BIOMESOP".equals(type.func_77127_a())) continue;
                WorldType orig = world.func_72912_H().func_76067_t();
                world.func_72912_H().func_76085_a(type);
                this.biomeProvider = type.getBiomeProvider(world);
                world.func_72912_H().func_76085_a(orig);
                break;
            }
        }
        return this.biomeProvider;
    }

    public BiomeProvider getBiomeProvider(World world) {
        LostCityProfile profile = WorldTypeTools.getProfile(world);
        if (profile.ALLOWED_BIOME_FACTORS.length == 0) {
            return this.getInternalBiomeProvider(world);
        }
        String[] outsideAllowedbiomeFactors = profile.ALLOWED_BIOME_FACTORS;
        String[] outsideManualBiomeMapping = profile.MANUAL_BIOME_MAPPINGS;
        BiomeSelectionStrategy outsideStrategy = null;
        if (profile.isSpace() && profile.CITYSPHERE_LANDSCAPE_OUTSIDE && !profile.CITYSPHERE_OUTSIDE_PROFILE.isEmpty()) {
            LostCityProfile outProfile = LostCityConfiguration.profiles.get(profile.CITYSPHERE_OUTSIDE_PROFILE);
            outsideAllowedbiomeFactors = outProfile.ALLOWED_BIOME_FACTORS;
            outsideManualBiomeMapping = outProfile.MANUAL_BIOME_MAPPINGS;
            outsideStrategy = outProfile.BIOME_SELECTION_STRATEGY;
        }
        return new LostWorldFilteredBiomeProvider(world, this.getInternalBiomeProvider(world), profile.ALLOWED_BIOME_FACTORS, profile.MANUAL_BIOME_MAPPINGS, profile.BIOME_SELECTION_STRATEGY, outsideAllowedbiomeFactors, outsideManualBiomeMapping, outsideStrategy);
    }

    public boolean isCustomizable() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void onCustomizeButton(Minecraft mc, GuiCreateWorld guiCreateWorld) {
        mc.func_147108_a((GuiScreen)new GuiLostCityConfiguration(guiCreateWorld));
    }

    public int getSpawnFuzz(WorldServer world, MinecraftServer server) {
        LostCityProfile profile = WorldTypeTools.getProfile((World)world);
        switch (profile.LANDSCAPE_TYPE) {
            case DEFAULT: 
            case FLOATING: {
                return super.getSpawnFuzz(world, server);
            }
            case SPACE: 
            case CAVERN: {
                return 0;
            }
        }
        return super.getSpawnFuzz(world, server);
    }

    public int getMinimumSpawnHeight(World world) {
        LostCityProfile profile = WorldTypeTools.getProfile(world);
        switch (profile.LANDSCAPE_TYPE) {
            case DEFAULT: 
            case FLOATING: {
                return super.getMinimumSpawnHeight(world);
            }
            case SPACE: 
            case CAVERN: {
                return profile.GROUNDLEVEL;
            }
        }
        return super.getMinimumSpawnHeight(world);
    }
}

