/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.collector.IMappingCollector;
import moze_intel.projecte.emc.json.NSSFake;
import moze_intel.projecte.emc.json.NSSFluid;
import moze_intel.projecte.emc.json.NSSItem;
import moze_intel.projecte.emc.json.NSSOreDictionary;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public interface NormalizedSimpleStack {
    public static Iterable<NormalizedSimpleStack> getVariants(String id) {
        Item i = Item.func_111206_d((String)id);
        if (i == null) {
            PECore.LOGGER.error("null item in getVariants");
            return Collections.emptyList();
        }
        NonNullList variants = NonNullList.func_191196_a();
        for (CreativeTabs group : i.getCreativeTabs()) {
            if (group == null) {
                variants.add((Object)new ItemStack(i));
                continue;
            }
            NonNullList subItems = NonNullList.func_191196_a();
            try {
                i.func_150895_a(group, subItems);
            }
            catch (LinkageError | RuntimeException e) {
                PECore.LOGGER.warn("couldn't get variants of {}: {}", (Object)i, (Object)e);
            }
            for (ItemStack sub : subItems) {
                if (sub.func_190926_b()) continue;
                variants.add((Object)sub);
            }
        }
        HashSet<NormalizedSimpleStack> ret = new HashSet<NormalizedSimpleStack>();
        for (ItemStack variant : variants) {
            ret.add(new NSSItem(variant.func_77973_b().getRegistryName().toString(), variant.func_77952_i()));
        }
        return ret;
    }

    public static <V extends Comparable<V>> void addMappings(IMappingCollector<NormalizedSimpleStack, V> mapper) {
        for (String string : NSSItem.seenIds) {
            NSSItem stackWildcard = new NSSItem(string, Short.MAX_VALUE);
            for (NormalizedSimpleStack variant : NormalizedSimpleStack.getVariants(string)) {
                mapper.addConversion(1, (NormalizedSimpleStack)stackWildcard, Collections.singletonList(variant));
            }
        }
        for (Map.Entry entry : NSSOreDictionary.oreDictStacks.entrySet()) {
            NormalizedSimpleStack oreDictStack = (NormalizedSimpleStack)entry.getValue();
            for (ItemStack i : ItemHelper.getODItems((String)entry.getKey())) {
                mapper.addConversion(1, oreDictStack, Collections.singletonList(NSSItem.create(i)));
                mapper.addConversion(1, NSSItem.create(i), Collections.singletonList(oreDictStack));
            }
        }
    }

    public boolean equals(Object var1);

    public String json();

    public static enum Serializer implements JsonSerializer<NormalizedSimpleStack>,
    JsonDeserializer<NormalizedSimpleStack>
    {
        INSTANCE;


        public NormalizedSimpleStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            int itemDamage;
            String s = json.getAsString();
            if (s.startsWith("OD|")) {
                return NSSOreDictionary.create(s.substring("OD|".length()));
            }
            if (s.startsWith("FAKE|")) {
                return NSSFake.create(s.substring("FAKE|".length()));
            }
            if (s.startsWith("FLUID|")) {
                String fluidName = s.substring("FLUID|".length());
                Fluid fluid = FluidRegistry.getFluid((String)fluidName);
                if (fluid == null) {
                    throw new JsonParseException("Tried to identify nonexistent Fluid " + fluidName);
                }
                return NSSFluid.create(fluid);
            }
            int pipeIndex = s.lastIndexOf(124);
            if (pipeIndex < 0) {
                throw new JsonParseException(String.format("Cannot parse '%s' as itemstack. Missing | to separate metadata.", s));
            }
            String itemName = s.substring(0, pipeIndex);
            String itemDamageString = s.substring(pipeIndex + 1);
            if (itemDamageString.equals("*")) {
                itemDamage = Short.MAX_VALUE;
            } else {
                try {
                    itemDamage = Integer.parseInt(itemDamageString);
                }
                catch (NumberFormatException e) {
                    throw new JsonParseException(String.format("Could not parse '%s' to metadata-integer", itemDamageString), (Throwable)e);
                }
            }
            return NSSItem.create(itemName, itemDamage);
        }

        public JsonElement serialize(NormalizedSimpleStack src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.json());
        }
    }
}

