/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.collector.IMappingCollector;
import moze_intel.projecte.emc.json.NSSItem;
import moze_intel.projecte.emc.json.NormalizedSimpleStack;
import moze_intel.projecte.emc.mappers.IEMCMapper;
import moze_intel.projecte.impl.ConversionProxyImpl;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class APICustomEMCMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    public static final APICustomEMCMapper instance = new APICustomEMCMapper();
    private static final int PRIORITY_MIN_VALUE = 0;
    private static final int PRIORITY_MAX_VALUE = 512;
    private static final int PRIORITY_DEFAULT_VALUE = 1;
    private final Map<String, Map<NormalizedSimpleStack, Long>> customEMCforMod = new HashMap<String, Map<NormalizedSimpleStack, Long>>();
    private final Map<String, Map<NormalizedSimpleStack, Long>> customNonItemEMCforMod = new HashMap<String, Map<NormalizedSimpleStack, Long>>();

    private APICustomEMCMapper() {
    }

    public void registerCustomEMC(ItemStack stack, long emcValue) {
        Map<Object, Object> modMap;
        ModContainer activeMod;
        String modId;
        if (stack.func_190926_b()) {
            return;
        }
        if (emcValue < 0L) {
            emcValue = 0L;
        }
        String string = modId = (activeMod = Loader.instance().activeModContainer()) == null ? null : activeMod.getModId();
        if (this.customEMCforMod.containsKey(modId)) {
            modMap = this.customEMCforMod.get(modId);
        } else {
            modMap = new HashMap();
            this.customEMCforMod.put(modId, modMap);
        }
        modMap.put(NSSItem.create(stack), emcValue);
    }

    public void registerCustomEMC(Object o, long emcValue) {
        Map<Object, Object> modMap;
        ModContainer activeMod;
        String modId;
        NormalizedSimpleStack stack = ConversionProxyImpl.instance.objectToNSS(o);
        if (stack == null) {
            return;
        }
        if (emcValue < 0L) {
            emcValue = 0L;
        }
        String string = modId = (activeMod = Loader.instance().activeModContainer()) == null ? null : activeMod.getModId();
        if (this.customNonItemEMCforMod.containsKey(modId)) {
            modMap = this.customNonItemEMCforMod.get(modId);
        } else {
            modMap = new HashMap();
            this.customNonItemEMCforMod.put(modId, modMap);
        }
        modMap.put(stack, emcValue);
    }

    @Override
    public String getName() {
        return "APICustomEMCMapper";
    }

    @Override
    public String getDescription() {
        return "Allows other mods to set EMC values using the ProjectEAPI";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, Configuration config) {
        HashMap<String, Integer> priorityMap = new HashMap<String, Integer>();
        HashSet<String> modIdSet = new HashSet<String>();
        modIdSet.addAll(this.customEMCforMod.keySet());
        modIdSet.addAll(this.customNonItemEMCforMod.keySet());
        for (String modId : modIdSet) {
            if (modId == null) continue;
            int n = 0;
            if (this.customEMCforMod.containsKey(modId)) {
                n += this.customEMCforMod.get(modId).size();
            }
            if (this.customNonItemEMCforMod.containsKey(modId)) {
                n += this.customNonItemEMCforMod.get(modId).size();
            }
            priorityMap.put(modId, config.getInt(modId + "priority", "customEMCPriorities", 1, 0, 512, "Priority for Mod with ModId = " + modId + ". Values: " + n));
        }
        if (modIdSet.contains(null)) {
            int valueCount = 0;
            if (this.customEMCforMod.containsKey(null)) {
                valueCount += this.customEMCforMod.get(null).size();
            }
            if (this.customNonItemEMCforMod.containsKey(null)) {
                valueCount += this.customNonItemEMCforMod.get(null).size();
            }
            priorityMap.put(null, config.getInt("modlessCustomEMCPriority", "", 1, 0, 512, "Priority for custom EMC values for which the ModId could not be determined. 0 to disable. Values: " + valueCount));
        }
        ArrayList<Object> modIds = new ArrayList<Object>(modIdSet);
        modIds.sort(Comparator.comparingInt(priorityMap::get).reversed());
        for (String string : modIds) {
            NormalizedSimpleStack normStack;
            String modIdOrUnknown;
            String string2 = modIdOrUnknown = string == null ? "unknown mod" : string;
            if (this.customEMCforMod.containsKey(string)) {
                for (Map.Entry<NormalizedSimpleStack, Long> entry : this.customEMCforMod.get(string).entrySet()) {
                    normStack = entry.getKey();
                    if (this.isAllowedToSet(string, normStack, entry.getValue(), config)) {
                        mapper.setValueBefore(normStack, (Long)((Comparable)entry.getValue()));
                        PECore.debugLog("{} setting value for {} to {}", modIdOrUnknown, normStack, entry.getValue());
                        continue;
                    }
                    PECore.debugLog("Disallowed {} to set the value for {} to {}", modIdOrUnknown, normStack, entry.getValue());
                }
            }
            if (!this.customNonItemEMCforMod.containsKey(string)) continue;
            for (Map.Entry<NormalizedSimpleStack, Long> entry : this.customNonItemEMCforMod.get(string).entrySet()) {
                normStack = entry.getKey();
                if (this.isAllowedToSet(string, normStack, entry.getValue(), config)) {
                    mapper.setValueBefore(normStack, (Long)((Comparable)entry.getValue()));
                    PECore.debugLog("{} setting value for {} to {}", modIdOrUnknown, normStack, entry.getValue());
                    continue;
                }
                PECore.debugLog("Disallowed {} to set the value for {} to {}", modIdOrUnknown, normStack, entry.getValue());
            }
        }
    }

    private boolean isAllowedToSet(String modId, NormalizedSimpleStack stack, Long value, Configuration config) {
        String itemName;
        if (stack instanceof NSSItem) {
            NSSItem item = (NSSItem)stack;
            itemName = item.itemName;
        } else {
            itemName = "IntermediateFakeItemsUsedInRecipes:";
        }
        String modForItem = itemName.substring(0, itemName.indexOf(58));
        String permission = config.getString(modForItem, "permissions." + modId, "both", String.format("Allow '%s' to set and or remove values for '%s'. Options: [both, set, remove, none]", modId, modForItem), new String[]{"both", "set", "remove", "none"});
        if (permission.equals("both")) {
            return true;
        }
        if (value == 0L) {
            return permission.equals("remove");
        }
        return permission.equals("set");
    }
}

