/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.IngredientMap;
import moze_intel.projecte.emc.collector.IMappingCollector;
import moze_intel.projecte.emc.json.NSSFake;
import moze_intel.projecte.emc.json.NSSItem;
import moze_intel.projecte.emc.json.NormalizedSimpleStack;
import moze_intel.projecte.emc.mappers.CraftTweakerRecipeMapper;
import moze_intel.projecte.emc.mappers.IEMCMapper;
import moze_intel.projecte.emc.mappers.RecipeStagesRecipeMapper;
import moze_intel.projecte.gameObjs.customRecipes.RecipeShapelessHidden;
import moze_intel.projecte.gameObjs.customRecipes.RecipeShapelessKleinStar;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CraftingMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    private final List<IRecipeMapper> recipeMappers = Arrays.asList(new VanillaRecipeMapper(), new PECustomRecipeMapper(), new CraftTweakerRecipeMapper(), new RecipeStagesRecipeMapper());
    private final Set<Class> canNotMap = new HashSet<Class>();
    private final Map<Class, Integer> recipeCount = new HashMap<Class, Integer>();

    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, Configuration config) {
        this.recipeCount.clear();
        this.canNotMap.clear();
        block2: for (IRecipe recipe : CraftingManager.field_193380_a) {
            boolean handled = false;
            ItemStack recipeOutput = recipe.func_77571_b();
            if (recipeOutput.func_190926_b()) continue;
            NormalizedSimpleStack recipeOutputNorm = NSSItem.create(recipeOutput);
            for (IRecipeMapper recipeMapper : this.recipeMappers) {
                if (!config.getBoolean("enable" + recipeMapper.getName(), "IRecipeImplementations", true, recipeMapper.getDescription()) || !recipeMapper.canHandle(recipe)) continue;
                handled = true;
                for (CraftingIngredients variation : recipeMapper.getIngredientsFor(recipe)) {
                    IngredientMap<NormalizedSimpleStack> ingredientMap = new IngredientMap<NormalizedSimpleStack>();
                    for (ItemStack itemStack : variation.fixedIngredients) {
                        if (itemStack.func_190926_b()) continue;
                        try {
                            if (itemStack.func_77952_i() != Short.MAX_VALUE && itemStack.func_77973_b().hasContainerItem(itemStack)) {
                                ingredientMap.addIngredient(NSSItem.create(itemStack.func_77973_b().getContainerItem(itemStack)), -1);
                            }
                            ingredientMap.addIngredient(NSSItem.create(itemStack), 1);
                        }
                        catch (Exception e) {
                            PECore.LOGGER.fatal("Exception in CraftingMapper when parsing Recipe Ingredients: RecipeType: {}, Ingredient: {}", (Object)recipe.getClass().getName(), (Object)itemStack.toString());
                            e.printStackTrace();
                            continue block2;
                        }
                    }
                    for (Iterable iterable : variation.multiIngredients) {
                        NormalizedSimpleStack dummy = NSSFake.create(iterable.toString());
                        ingredientMap.addIngredient(dummy, 1);
                        for (ItemStack stack : iterable) {
                            if (stack.func_190926_b()) continue;
                            IngredientMap<NormalizedSimpleStack> groupIngredientMap = new IngredientMap<NormalizedSimpleStack>();
                            if (stack.func_77973_b().hasContainerItem(stack)) {
                                groupIngredientMap.addIngredient(NSSItem.create(stack.func_77973_b().getContainerItem(stack)), -1);
                            }
                            groupIngredientMap.addIngredient(NSSItem.create(stack), 1);
                            mapper.addConversion(1, dummy, groupIngredientMap.getMap());
                        }
                    }
                    mapper.addConversion(recipeOutput.func_190916_E(), recipeOutputNorm, ingredientMap.getMap());
                }
            }
            if (!handled) {
                if (!this.canNotMap.add(recipe.getClass())) continue;
                PECore.debugLog("Can not map Crafting Recipes with Type: {}", recipe.getClass().getName());
                continue;
            }
            int count = 0;
            if (this.recipeCount.containsKey(recipe.getClass())) {
                count = this.recipeCount.get(recipe.getClass());
            }
            this.recipeCount.put(recipe.getClass(), ++count);
        }
        PECore.debugLog("CraftingMapper Statistics:", new Object[0]);
        for (Map.Entry<Class, Integer> entry : this.recipeCount.entrySet()) {
            PECore.debugLog("Found {} Recipes of Type {}", entry.getValue(), entry.getKey());
        }
    }

    @Override
    public String getName() {
        return "CraftingMapper";
    }

    @Override
    public String getDescription() {
        return "Add Conversions for Crafting Recipes gathered from net.minecraft.item.crafting.CraftingManager";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    private static class PECustomRecipeMapper
    implements IRecipeMapper {
        private PECustomRecipeMapper() {
        }

        @Override
        public String getName() {
            return "PECustomRecipeMapper";
        }

        @Override
        public String getDescription() {
            return "Maps custom IRecipe's from ProjectE";
        }

        @Override
        public boolean canHandle(IRecipe recipe) {
            return recipe instanceof RecipeShapelessKleinStar || recipe instanceof RecipeShapelessHidden;
        }
    }

    private static class VanillaRecipeMapper
    implements IRecipeMapper {
        private VanillaRecipeMapper() {
        }

        @Override
        public String getName() {
            return "VanillaRecipeMapper";
        }

        @Override
        public String getDescription() {
            return "Maps `IRecipe` crafting recipes that extend `ShapedRecipes` or `ShapelessRecipes`, and their oredict equivalents";
        }

        @Override
        public boolean canHandle(IRecipe recipe) {
            return recipe instanceof ShapedRecipes || recipe instanceof ShapelessRecipes || recipe instanceof ShapedOreRecipe || recipe instanceof ShapelessOreRecipe;
        }
    }

    private static class CraftingIngredients {
        public final Iterable<ItemStack> fixedIngredients;
        public final Iterable<Iterable<ItemStack>> multiIngredients;

        public CraftingIngredients(Iterable<ItemStack> fixedIngredients, Iterable<Iterable<ItemStack>> multiIngredients) {
            this.fixedIngredients = fixedIngredients;
            this.multiIngredients = multiIngredients;
        }
    }

    public static interface IRecipeMapper {
        public String getName();

        public String getDescription();

        public boolean canHandle(IRecipe var1);

        default public Iterable<CraftingIngredients> getIngredientsFor(IRecipe recipe) {
            ArrayList<Iterable<ItemStack>> variableInputs = new ArrayList<Iterable<ItemStack>>();
            ArrayList<ItemStack> fixedInputs = new ArrayList<ItemStack>();
            for (Ingredient recipeItem : recipe.func_192400_c()) {
                ItemStack[] matches = recipeItem.func_193365_a();
                if (matches.length == 1) {
                    fixedInputs.add(matches[0].func_77946_l());
                    continue;
                }
                if (matches.length <= 0) continue;
                LinkedList<ItemStack> recipeItemOptions = new LinkedList<ItemStack>();
                for (ItemStack option : matches) {
                    recipeItemOptions.add(option.func_77946_l());
                }
                variableInputs.add(recipeItemOptions);
            }
            return Collections.singletonList(new CraftingIngredients(fixedInputs, variableInputs));
        }
    }
}

