/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.jei.collectors;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CollectorRecipeCategory
implements IRecipeCategory {
    public static final String UID = "pe.collector";
    private final IDrawable background;
    private final IDrawable arrow;
    private final IDrawable icon;
    private final String localizedName;

    public CollectorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(175, 48);
        this.arrow = guiHelper.createDrawable(new ResourceLocation("projecte", "textures/gui/arrow.png"), 0, 0, 22, 15, 32, 32);
        this.icon = guiHelper.createDrawable(new ResourceLocation("projecte", "textures/blocks/collectors/front.png"), 0, 0, 16, 16, 16, 16);
        this.localizedName = I18n.func_135052_a((String)"pe.nei.collector", (Object[])new Object[0]);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public String getModName() {
        return "ProjectE";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.arrow.draw(minecraft, 75, 18);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        int itemSlots = 0;
        int xPos = 16;
        for (List s : ingredients.getInputs(ItemStack.class)) {
            recipeLayout.getItemStacks().init(itemSlots, true, xPos, 16);
            recipeLayout.getItemStacks().set(itemSlots, s);
            ++itemSlots;
            xPos += 16;
        }
        xPos = 136;
        for (List stacks : ingredients.getOutputs(ItemStack.class)) {
            recipeLayout.getItemStacks().init(itemSlots, false, xPos, 16);
            recipeLayout.getItemStacks().set(itemSlots, stacks);
            ++itemSlots;
            xPos += 16;
        }
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Collections.emptyList();
    }
}

