/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IAlchBagProvider;
import moze_intel.projecte.gameObjs.container.AlchBagContainer;
import moze_intel.projecte.impl.AlchBagImpl;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.ShowBagPKT;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ShowBagCMD
extends CommandBase {
    public String func_71517_b() {
        return "showBag";
    }

    public String func_71518_a(ICommandSender sender) {
        return "pe.command.showbag.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EnumDyeColor color;
        if (!(sender instanceof EntityPlayerMP)) {
            throw new CommandException("pe.command.showbag.notplayer", new Object[0]);
        }
        if (args.length != 2) {
            throw new WrongUsageException("pe.command.showbag.usage", new Object[0]);
        }
        EntityPlayerMP senderPlayer = (EntityPlayerMP)sender;
        try {
            color = EnumDyeColor.valueOf((String)args[0].toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            throw new CommandException("pe.command.showbag.nocolor", new Object[]{args[0]});
        }
        senderPlayer.func_71053_j();
        senderPlayer.func_71117_bO();
        senderPlayer.field_71070_bA = ShowBagCMD.createContainer(server, senderPlayer, args[1], color);
        senderPlayer.field_71070_bA.field_75152_c = senderPlayer.field_71139_cq;
        PacketHandler.sendTo(new ShowBagPKT(senderPlayer.field_71070_bA.field_75152_c), senderPlayer);
        senderPlayer.field_71070_bA.func_75132_a((IContainerListener)senderPlayer);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return ShowBagCMD.func_175762_a((String[])args, Arrays.asList(EnumDyeColor.values()));
        }
        if (args.length == 2) {
            return ShowBagCMD.func_175762_a((String[])args, Arrays.asList(server.func_71213_z()));
        }
        return Collections.emptyList();
    }

    private static Container createContainer(MinecraftServer server, EntityPlayerMP sender, String playerArg, EnumDyeColor color) throws CommandException {
        try {
            final EntityPlayerMP target = ShowBagCMD.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)playerArg);
            IItemHandlerModifiable inv = (IItemHandlerModifiable)((IAlchBagProvider)target.getCapability(ProjectEAPI.ALCH_BAG_CAPABILITY, null)).getBag(color);
            return new AlchBagContainer(sender.field_71071_by, EnumHand.OFF_HAND, inv){

                @Override
                public boolean func_75145_c(@Nonnull EntityPlayer player) {
                    return target.func_70089_S() && !target.func_193105_t();
                }
            };
        }
        catch (PlayerNotFoundException target) {
            UUID uuid;
            try {
                uuid = UUID.fromString(playerArg);
            }
            catch (IllegalArgumentException ex) {
                throw new CommandException("pe.command.showbag.offline.uuid", new Object[0]);
            }
            IItemHandlerModifiable inv = ShowBagCMD.loadOfflineBag(uuid, color);
            return new AlchBagContainer(sender.field_71071_by, EnumHand.OFF_HAND, inv, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IItemHandlerModifiable loadOfflineBag(UUID playerUUID, EnumDyeColor color) throws CommandException {
        File player;
        File playerData = new File(DimensionManager.getCurrentSaveRootDirectory(), "playerdata");
        if (playerData.exists() && (player = new File(playerData, playerUUID.toString() + ".dat")).exists() && player.isFile()) {
            try (FileInputStream in = new FileInputStream(player);){
                NBTTagCompound playerDat = CompressedStreamTools.func_74796_a((InputStream)in);
                NBTTagCompound bagProvider = playerDat.func_74775_l("ForgeCaps").func_74775_l(AlchBagImpl.Provider.NAME.toString());
                IAlchBagProvider provider = (IAlchBagProvider)ProjectEAPI.ALCH_BAG_CAPABILITY.getDefaultInstance();
                ProjectEAPI.ALCH_BAG_CAPABILITY.readNBT((Object)provider, null, (NBTBase)bagProvider);
                IItemHandlerModifiable iItemHandlerModifiable = (IItemHandlerModifiable)provider.getBag(color);
                return iItemHandlerModifiable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new CommandException("pe.command.showbag.offline.notfound", new Object[]{playerUUID.toString()});
    }
}

