/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.util;

import amerifrance.guideapi.api.GuideAPI;
import amerifrance.guideapi.api.impl.Book;
import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class APISetter {
    public static void registerBook(Book book) {
        try {
            APISetter.sanityCheck();
        }
        catch (IllegalAccessException e) {
            Throwables.propagate((Throwable)e);
            return;
        }
        try {
            Field books = GuideAPI.class.getDeclaredField("BOOKS");
            books.setAccessible(true);
            Map BOOKS = (Map)books.get(null);
            BOOKS.put(book.getRegistryName(), book);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setBookForStack(Book book, ItemStack stack) {
        try {
            APISetter.sanityCheck();
        }
        catch (IllegalAccessException e) {
            Throwables.propagate((Throwable)e);
            return;
        }
        try {
            Field stacks = GuideAPI.class.getDeclaredField("BOOK_TO_STACK");
            stacks.setAccessible(true);
            Map BOOK_TO_STACK = (Map)stacks.get(null);
            BOOK_TO_STACK.put(book, stack);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setIndexedBooks(List<Book> books) {
        try {
            APISetter.sanityCheck();
        }
        catch (IllegalAccessException e) {
            Throwables.propagate((Throwable)e);
            return;
        }
        try {
            Field indexedBooks = GuideAPI.class.getDeclaredField("indexedBooks");
            indexedBooks.setAccessible(true);
            indexedBooks.set(null, books);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void sanityCheck() throws IllegalAccessException {
        ModContainer activeMod = Loader.instance().activeModContainer();
        if (!activeMod.getModId().equals("guideapi")) {
            throw new IllegalAccessException("Mod " + activeMod.getModId() + " tried to access an internal-only method in GuideAPI. Please report this.");
        }
    }
}

