/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder;

import com.wimbli.WorldBorder.BorderData;
import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.forge.Location;
import com.wimbli.WorldBorder.forge.Log;
import com.wimbli.WorldBorder.forge.Particles;
import com.wimbli.WorldBorder.forge.Util;
import com.wimbli.WorldBorder.forge.Worlds;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BorderCheck {
    public static Location checkPlayer(EntityPlayerMP player, Location targetLoc, boolean returnLocationOnly, boolean notify) {
        if (player == null) {
            return null;
        }
        Location loc = targetLoc == null ? new Location((EntityPlayer)player) : targetLoc;
        WorldServer world = loc.world;
        if (world == null) {
            return null;
        }
        BorderData border = Config.Border(Worlds.getWorldName((World)world));
        if (border == null) {
            return null;
        }
        if (border.insideBorder(loc.posX, loc.posZ, Config.getShapeRound())) {
            return null;
        }
        if (Config.isPlayerBypassing(player.func_110124_au())) {
            return null;
        }
        Location newLoc = BorderCheck.newLocation(player, loc, border, notify);
        if (player.func_184218_aH()) {
            Entity ride = player.func_184187_bx();
            player.func_184210_p();
            if (ride != null) {
                double vertOffset = ride instanceof EntityLiving ? 0.0 : ride.field_70163_u - loc.posY;
                Location rideLoc = new Location(newLoc);
                rideLoc.posY = newLoc.posY + vertOffset;
                Log.trace("Player was riding a \"" + ride.toString() + "\".", new Object[0]);
                if (ride instanceof EntityBoat) {
                    ride.func_70106_y();
                    ride = new EntityBoat((World)world, rideLoc.posX, rideLoc.posY, rideLoc.posZ);
                    world.func_72838_d(ride);
                } else {
                    ride.func_70080_a(rideLoc.posX, rideLoc.posY, rideLoc.posZ, rideLoc.pitch, rideLoc.yaw);
                }
                if (Config.getRemount()) {
                    player.func_184220_m(ride);
                }
            }
        }
        if (player.func_184188_bt() != null) {
            player.func_184226_ay();
            for (Entity rider : player.func_184188_bt()) {
                rider.func_70080_a(newLoc.posX, newLoc.posY, newLoc.posZ, newLoc.pitch, newLoc.yaw);
                Log.trace("%s had %s riding on them", player.func_145748_c_(), rider.func_174793_f().func_70005_c_());
            }
        }
        if (Config.doWhooshEffect()) {
            Particles.showWhooshEffect(player);
        }
        if (!returnLocationOnly) {
            player.func_70634_a(newLoc.posX, newLoc.posY, newLoc.posZ);
        }
        if (returnLocationOnly) {
            return newLoc;
        }
        return null;
    }

    private static Location newLocation(EntityPlayerMP player, Location loc, BorderData border, boolean notify) {
        Log.trace("%s @ world '%s'. Border: %s", notify ? "Border crossing" : "Check was run", Worlds.getWorldName((World)loc.world), border);
        Log.trace("Player @ X: %.2f Y: %.2f Z: %.2f", loc.posX, loc.posY, loc.posZ);
        Location newLoc = border.correctedPosition(loc, Config.getShapeRound(), player.field_71075_bZ.field_75100_b);
        if (newLoc == null) {
            Log.debug("Target new location unviable, trying again with border center.", new Object[0]);
            double safeY = border.getSafeY(loc.world, (int)border.getX(), 64, (int)border.getZ(), player.field_71075_bZ.field_75100_b);
            if (safeY != 1.0) {
                newLoc = new Location(loc);
                newLoc.posX = Math.floor(border.getX()) + 0.5;
                newLoc.posY = safeY;
                newLoc.posZ = Math.floor(border.getZ()) + 0.5;
            }
        }
        if (newLoc == null) {
            Log.debug("Target new location still unviable, using spawn or killing player.", new Object[0]);
            if (Config.doPlayerKill()) {
                player.func_70606_j(0.0f);
                return null;
            }
            newLoc = new Location((WorldServer)player.field_70170_p);
        }
        Log.trace("New position @ X: %.2f Y: %.2f Z: %.2f", newLoc.posX, newLoc.posY, newLoc.posZ);
        if (notify) {
            Util.chat((ICommandSender)player, Config.getMessage(), new Object[0]);
        }
        return newLoc;
    }
}

