/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.wimbli.WorldBorder.WorldBorder;
import com.wimbli.WorldBorder.cmd.CmdBypass;
import com.wimbli.WorldBorder.cmd.CmdBypasslist;
import com.wimbli.WorldBorder.cmd.CmdClear;
import com.wimbli.WorldBorder.cmd.CmdCommands;
import com.wimbli.WorldBorder.cmd.CmdDelay;
import com.wimbli.WorldBorder.cmd.CmdDenypearl;
import com.wimbli.WorldBorder.cmd.CmdDynmap;
import com.wimbli.WorldBorder.cmd.CmdDynmapmsg;
import com.wimbli.WorldBorder.cmd.CmdFill;
import com.wimbli.WorldBorder.cmd.CmdFillautosave;
import com.wimbli.WorldBorder.cmd.CmdGetmsg;
import com.wimbli.WorldBorder.cmd.CmdHelp;
import com.wimbli.WorldBorder.cmd.CmdKnockback;
import com.wimbli.WorldBorder.cmd.CmdList;
import com.wimbli.WorldBorder.cmd.CmdPreventPlace;
import com.wimbli.WorldBorder.cmd.CmdPreventSpawn;
import com.wimbli.WorldBorder.cmd.CmdRadius;
import com.wimbli.WorldBorder.cmd.CmdReload;
import com.wimbli.WorldBorder.cmd.CmdRemount;
import com.wimbli.WorldBorder.cmd.CmdSet;
import com.wimbli.WorldBorder.cmd.CmdSetcorners;
import com.wimbli.WorldBorder.cmd.CmdSetmsg;
import com.wimbli.WorldBorder.cmd.CmdShape;
import com.wimbli.WorldBorder.cmd.CmdTrim;
import com.wimbli.WorldBorder.cmd.CmdWhoosh;
import com.wimbli.WorldBorder.cmd.CmdWrap;
import com.wimbli.WorldBorder.cmd.CmdWshape;
import com.wimbli.WorldBorder.cmd.WBCmd;
import com.wimbli.WorldBorder.forge.Log;
import com.wimbli.WorldBorder.forge.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.util.math.BlockPos;

public class WBCommand
implements ICommand {
    static final String NAME = "wborder";
    static final List ALIASES = Arrays.asList("wborder", "wb", "worldborder");
    public Map<String, WBCmd> subCommands = new LinkedHashMap<String, WBCmd>();
    private Set<String> subCommandsWithWorldNames = new LinkedHashSet<String>();
    private ArrayList<String> subCommandNames = null;

    public static void checkRegistrations(MinecraftServer server) {
        ArrayList<String> valid = new ArrayList<String>(ALIASES.size());
        ArrayList<String> conflict = new ArrayList<String>(ALIASES.size());
        Map commands = server.func_71187_D().func_71555_a();
        for (Object o : ALIASES) {
            String name = (String)o;
            Object value = commands.get(name);
            if (value == null) {
                Log.error("Null handler for '/%s'! Please report this", name);
                continue;
            }
            if (value instanceof WBCommand) {
                valid.add("/" + name);
                continue;
            }
            conflict.add(String.format("/%s (from %s)", name, value.getClass().getName()));
        }
        if (valid.size() == 0) {
            Log.error("All WorldBorder commands are being handled elsewhere:", new Object[0]);
            for (String c : conflict) {
                Log.error("* %s", c);
            }
            Log.error("It may be that another mod is attempting to provide world border functionality. Consider removing or disabling that mod to allow WorldBorder-Forge to work properly.", new Object[0]);
        } else if (conflict.size() > 0) {
            Log.warn("The following WorldBorder commands are being handled elsewhere:", new Object[0]);
            for (String c : conflict) {
                Log.warn("* %s", c);
            }
            Log.warn("It may be that another mod is attempting to provide world border functionality. Consider removing or disabling that mod to allow WorldBorder-Forge to work. Alternatively, try these commands:", new Object[0]);
            for (String v : valid) {
                Log.warn("* %s", v);
            }
        }
    }

    public WBCommand() {
        this.addCmd(new CmdHelp());
        this.addCmd(new CmdSet());
        this.addCmd(new CmdSetcorners());
        this.addCmd(new CmdRadius());
        this.addCmd(new CmdList());
        this.addCmd(new CmdShape());
        this.addCmd(new CmdClear());
        this.addCmd(new CmdFill());
        this.addCmd(new CmdTrim());
        this.addCmd(new CmdBypass());
        this.addCmd(new CmdBypasslist());
        this.addCmd(new CmdKnockback());
        this.addCmd(new CmdWrap());
        this.addCmd(new CmdWhoosh());
        this.addCmd(new CmdGetmsg());
        this.addCmd(new CmdSetmsg());
        this.addCmd(new CmdWshape());
        this.addCmd(new CmdPreventPlace());
        this.addCmd(new CmdPreventSpawn());
        this.addCmd(new CmdDelay());
        this.addCmd(new CmdDynmap());
        this.addCmd(new CmdDynmapmsg());
        this.addCmd(new CmdRemount());
        this.addCmd(new CmdFillautosave());
        this.addCmd(new CmdDenypearl());
        this.addCmd(new CmdReload());
        this.addCmd(new CmdCommands());
    }

    private void addCmd(WBCmd cmd) {
        this.subCommands.put(cmd.name, cmd);
        if (cmd.hasWorldNameInput) {
            this.subCommandsWithWorldNames.add(cmd.name);
        }
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] split) throws CommandException {
        EntityPlayerMP player = sender instanceof EntityPlayerMP ? (EntityPlayerMP)sender : null;
        ArrayList params = Lists.newArrayList((Object[])split);
        String worldName = null;
        if (params.size() > 1 && !this.subCommands.containsKey(params.get(0)) && this.subCommandsWithWorldNames.contains(params.get(1))) {
            worldName = (String)params.get(0);
        }
        if (params.isEmpty()) {
            params.add(0, "commands");
        }
        String cmdName = worldName == null ? ((String)params.get(0)).toLowerCase() : ((String)params.get(1)).toLowerCase();
        params.remove(0);
        if (worldName != null) {
            params.remove(0);
        }
        if (!this.subCommands.containsKey(cmdName)) {
            int page = player == null ? 0 : 1;
            try {
                page = Integer.parseInt(cmdName);
            }
            catch (NumberFormatException ignored) {
                Util.chat(sender, WBCmd.C_ERR + "Command not recognized. Showing command list.", new Object[0]);
            }
            cmdName = "commands";
            params.add(0, Integer.toString(page));
        }
        WBCmd subCommand = this.subCommands.get(cmdName);
        if (player == null && subCommand.hasWorldNameInput && subCommand.consoleRequiresWorldName && worldName == null) {
            Util.chat(sender, WBCmd.C_ERR + "This command requires a world to be specified if run by the console.", new Object[0]);
            subCommand.sendCmdHelp(sender);
            return;
        }
        if (params.size() < subCommand.minParams || params.size() > subCommand.maxParams) {
            if (subCommand.maxParams == 0) {
                Util.chat(sender, WBCmd.C_ERR + "This command does not accept any parameters.", new Object[0]);
            } else {
                Util.chat(sender, WBCmd.C_ERR + "You have not provided a valid number of parameters.", new Object[0]);
            }
            subCommand.sendCmdHelp(sender);
            return;
        }
        subCommand.execute(sender, player, params, worldName);
    }

    public ArrayList<String> getCommandNames() {
        if (this.subCommandNames != null) {
            return this.subCommandNames;
        }
        this.subCommandNames = new ArrayList<String>(this.subCommands.keySet());
        this.subCommandNames.remove("commands");
        Collections.sort(this.subCommandNames);
        return this.subCommandNames;
    }

    public String func_71517_b() {
        return NAME;
    }

    public String func_71518_a(ICommandSender sender) {
        return "/wborder help [n]";
    }

    public List func_71514_a() {
        return ALIASES;
    }

    public boolean func_82358_a(String[] args, int idx) {
        return false;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        if (sender instanceof DedicatedServer) {
            return true;
        }
        EntityPlayerMP player = (EntityPlayerMP)sender;
        GameProfile profile = player.func_146103_bH();
        UserListOpsEntry opEntry = (UserListOpsEntry)WorldBorder.SERVER.func_184103_al().func_152603_m().func_152683_b((Object)profile);
        return opEntry != null && opEntry.func_152644_a() > 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length <= 1) {
            return CommandBase.func_175762_a((String[])args, this.getCommandNames());
        }
        String[] players = WorldBorder.SERVER.func_71213_z();
        return CommandBase.func_71530_a((String[])args, (String[])players);
    }

    public int compareTo(ICommand o) {
        return o.func_71517_b().compareTo(this.func_71517_b());
    }
}

