/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder.cmd;

import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.cmd.WBCmd;
import com.wimbli.WorldBorder.forge.Util;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;

public class CmdFillautosave
extends WBCmd {
    public CmdFillautosave() {
        this.permission = "fillautosave";
        this.name = "fillautosave";
        this.maxParams = 1;
        this.minParams = 1;
        this.addCmdExample(this.nameEmphasized() + "<seconds> - world save interval for Fill.");
        this.helpText = "Default value: 30 seconds.";
    }

    @Override
    public void cmdStatus(ICommandSender sender) {
        int seconds = Config.getFillAutosaveFrequency();
        if (seconds == 0) {
            Util.chat(sender, C_HEAD + "World autosave frequency during Fill process is set to 0, disabling it.", new Object[0]);
            Util.chat(sender, C_HEAD + "Note that much progress can be lost this way if there is a bug or crash in the world generation process from Bukkit or any world generation plugin you use.", new Object[0]);
        } else {
            Util.chat(sender, C_HEAD + "World autosave frequency during Fill process is set to " + seconds + " seconds (rounded to a multiple of 5).", new Object[0]);
            Util.chat(sender, C_HEAD + "New chunks generated by the Fill process will be forcibly saved to disk this often to prevent loss of progress due to bugs or crashes in the world generation process.", new Object[0]);
        }
    }

    @Override
    public void execute(ICommandSender sender, EntityPlayerMP player, List<String> params, String worldName) {
        int seconds = 0;
        try {
            seconds = Integer.parseInt(params.get(0));
            if (seconds < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            this.sendErrorAndHelp(sender, "The world autosave frequency must be an integer of 0 or higher. Setting to 0 will disable autosaving of the world during the Fill process.");
            return;
        }
        Config.setFillAutosaveFrequency(seconds);
        if (player != null) {
            this.cmdStatus(sender);
        }
    }
}

