/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder.cmd;

import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.cmd.WBCmd;
import com.wimbli.WorldBorder.forge.Util;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;

public class CmdKnockback
extends WBCmd {
    public CmdKnockback() {
        this.permission = "knockback";
        this.name = "knockback";
        this.maxParams = 1;
        this.minParams = 1;
        this.addCmdExample(this.nameEmphasized() + "<distance> - how far to move the player back.");
        this.helpText = "Default value: 3.0 (blocks). Players who cross the border will be knocked back to this distance inside.";
    }

    @Override
    public void cmdStatus(ICommandSender sender) {
        double kb = Config.getKnockBack();
        if (kb < 1.0) {
            Util.chat(sender, C_HEAD + "Knockback is set to 0, disabling border enforcement.", new Object[0]);
        } else {
            Util.chat(sender, C_HEAD + "Knockback is set to " + kb + " blocks inside the border.", new Object[0]);
        }
    }

    @Override
    public void execute(ICommandSender sender, EntityPlayerMP player, List<String> params, String worldName) {
        float numBlocks = 0.0f;
        try {
            numBlocks = Float.parseFloat(params.get(0));
            if ((double)numBlocks < 0.0 || (double)numBlocks > 0.0 && (double)numBlocks < 1.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            this.sendErrorAndHelp(sender, "The knockback must be a decimal value of at least 1.0, or it can be 0.");
            return;
        }
        Config.setKnockBack(numBlocks);
        if (player != null) {
            this.cmdStatus(sender);
        }
    }
}

