/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder.cmd;

import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.CoordXZ;
import com.wimbli.WorldBorder.cmd.WBCmd;
import com.wimbli.WorldBorder.forge.Log;
import com.wimbli.WorldBorder.forge.Util;
import com.wimbli.WorldBorder.forge.Worlds;
import com.wimbli.WorldBorder.task.WorldTrimTask;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;

public class CmdTrim
extends WBCmd {
    private final int defaultPadding = CoordXZ.chunkToBlock(13);
    private String trimWorld = "";
    private int trimFrequency = 5000;
    private int trimPadding = this.defaultPadding;

    public CmdTrim() {
        this.permission = "trim";
        this.name = "trim";
        this.hasWorldNameInput = true;
        this.consoleRequiresWorldName = false;
        this.minParams = 0;
        this.maxParams = 2;
        this.addCmdExample(this.nameEmphasizedW() + "[freq] [pad] - trim world outside of border.");
        this.helpText = "This command will remove chunks which are outside the world's border. [freq] is the frequency of chunks per second that will be checked (default 5000). [pad] is the number of blocks padding kept beyond the border itself (default 208, to cover player visual range).";
    }

    @Override
    public void execute(ICommandSender sender, EntityPlayerMP player, List<String> params, String worldName) {
        boolean confirm = false;
        if (params.size() >= 1) {
            String check = params.get(0).toLowerCase();
            if (check.equals("cancel") || check.equals("stop")) {
                if (!this.makeSureTrimIsRunning(sender)) {
                    return;
                }
                Util.chat(sender, C_HEAD + "Cancelling the world map trimming task.", new Object[0]);
                this.trimDefaults();
                WorldTrimTask.getInstance().stop();
                return;
            }
            if (check.equals("pause")) {
                if (!this.makeSureTrimIsRunning(sender)) {
                    return;
                }
                WorldTrimTask.getInstance().pause();
                Util.chat(sender, C_HEAD + "The world map trimming task is now " + (WorldTrimTask.getInstance().isPaused() ? "" : "un") + "paused.", new Object[0]);
                return;
            }
            confirm = check.equals("confirm");
        }
        if (worldName == null && !confirm) {
            if (player != null) {
                worldName = Worlds.getWorldName(player.field_70170_p);
            } else {
                this.sendErrorAndHelp(sender, "You must specify a world!");
                return;
            }
        }
        String cmd = this.cmd(sender) + this.nameEmphasized() + C_CMD;
        if (WorldTrimTask.getInstance() != null) {
            Util.chat(sender, C_ERR + "The world map trimming task is already running.", new Object[0]);
            Util.chat(sender, C_DESC + "You can cancel at any time with " + cmd + "cancel" + C_DESC + ", or pause/unpause with " + cmd + "pause" + C_DESC + ".", new Object[0]);
            return;
        }
        try {
            if (params.size() >= 1 && !confirm) {
                this.trimFrequency = Math.abs(Integer.parseInt(params.get(0)));
            }
            if (params.size() >= 2 && !confirm) {
                this.trimPadding = Math.abs(Integer.parseInt(params.get(1)));
            }
        }
        catch (NumberFormatException ex) {
            this.sendErrorAndHelp(sender, "The frequency and padding values must be integers.");
            this.trimDefaults();
            return;
        }
        if (this.trimFrequency <= 0) {
            this.sendErrorAndHelp(sender, "The frequency value must be greater than zero.");
            this.trimDefaults();
            return;
        }
        if (worldName != null) {
            this.trimWorld = worldName;
        }
        if (confirm) {
            if (this.trimWorld.isEmpty()) {
                this.sendErrorAndHelp(sender, "You must first use this command successfully without confirming.");
                return;
            }
            if (player != null) {
                Log.info("Trimming world beyond border at the command of player \"" + player.func_145748_c_() + "\".", new Object[0]);
            }
            int ticks = 1;
            int repeats = 1;
            if (this.trimFrequency > 20) {
                repeats = this.trimFrequency / 20;
            } else {
                ticks = 20 / this.trimFrequency;
            }
            try {
                WorldTrimTask task = WorldTrimTask.create((ICommandSender)player, this.trimWorld, this.trimPadding, repeats, ticks);
                task.start();
                Util.chat(sender, "WorldBorder map trimming task for world \"" + this.trimWorld + "\" started.", new Object[0]);
            }
            catch (Exception e) {
                Util.chat(sender, C_ERR + "The world map trimming task failed to start.", new Object[0]);
                Util.chat(sender, C_ERR + e.getMessage(), new Object[0]);
            }
            this.trimDefaults();
        } else {
            if (this.trimWorld.isEmpty() || Worlds.getWorld(this.trimWorld) == null) {
                this.sendErrorAndHelp(sender, "You must first specify a valid world.");
                return;
            }
            if (Config.Border(this.trimWorld) == null) {
                this.sendErrorAndHelp(sender, "That world does not have a border.");
                return;
            }
            Util.chat(sender, C_HEAD + "World trimming task is ready for world \"" + this.trimWorld + "\", attempting to process up to " + this.trimFrequency + " chunks per second (default 5000). The map will be trimmed past " + this.trimPadding + " blocks beyond the border (default " + this.defaultPadding + ").", new Object[0]);
            Util.chat(sender, C_HEAD + "This process can take a very long time depending on the world's overall size. Also, depending on the chunk processing rate, players may experience lag for the duration.", new Object[0]);
            Util.chat(sender, C_DESC + "You should now use " + cmd + "confirm" + C_DESC + " to start the process.", new Object[0]);
            Util.chat(sender, C_DESC + "You can cancel at any time with " + cmd + "cancel" + C_DESC + ", or pause/unpause with " + cmd + "pause" + C_DESC + ".", new Object[0]);
        }
    }

    private void trimDefaults() {
        this.trimWorld = "";
        this.trimFrequency = 5000;
        this.trimPadding = this.defaultPadding;
    }

    private boolean makeSureTrimIsRunning(ICommandSender sender) {
        if (WorldTrimTask.getInstance() != null) {
            return true;
        }
        this.sendErrorAndHelp(sender, "The world map trimming task is not currently running.");
        return false;
    }
}

