/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder.cmd;

import com.wimbli.WorldBorder.forge.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.TextFormatting;

public abstract class WBCmd {
    public String name = "";
    public String permission = null;
    public boolean hasWorldNameInput = false;
    public boolean consoleRequiresWorldName = true;
    public int minParams = 0;
    public int maxParams = 9999;
    public String helpText = null;
    public static final String C_CMD = TextFormatting.AQUA.toString();
    public static final String C_DESC = TextFormatting.WHITE.toString();
    public static final String C_ERR = TextFormatting.RED.toString();
    public static final String C_HEAD = TextFormatting.YELLOW.toString();
    public static final String C_OPT = TextFormatting.DARK_GREEN.toString();
    public static final String C_REQ = TextFormatting.GREEN.toString();
    public static final String CMD_C = C_CMD + "wb ";
    public static final String CMD_P = C_CMD + "/wb ";
    public List<String> cmdExamplePlayer = new ArrayList<String>();
    public List<String> cmdExampleConsole = new ArrayList<String>();
    public static final List<String> cmdExamplesConsole = new ArrayList<String>(48);
    public static final List<String> cmdExamplesPlayer = new ArrayList<String>(48);

    public abstract void execute(ICommandSender var1, EntityPlayerMP var2, List<String> var3, String var4);

    public void cmdStatus(ICommandSender sender) {
    }

    public void addCmdExample(String example) {
        this.addCmdExample(example, true, true, true);
    }

    public void addCmdExample(String example, boolean forPlayer, boolean forConsole, boolean prefix) {
        example = example.replace("<", C_REQ + "<").replace("[", C_OPT + "[").replace("^", C_CMD).replace("- ", C_DESC + "- ");
        if (forPlayer) {
            String exampleP = (prefix ? CMD_P : "") + example.replace("{", C_OPT + "[").replace("}", "]");
            this.cmdExamplePlayer.add(exampleP);
            cmdExamplesPlayer.add(exampleP);
        }
        if (forConsole) {
            String exampleC = (prefix ? CMD_C : "") + example.replace("{", C_REQ + "<").replace("}", ">");
            this.cmdExampleConsole.add(exampleC);
            cmdExamplesConsole.add(exampleC);
        }
    }

    public String cmd(ICommandSender sender) {
        return sender instanceof EntityPlayerMP ? CMD_P : CMD_C;
    }

    public String commandEmphasized(String text) {
        return C_CMD + TextFormatting.UNDERLINE + text + TextFormatting.RESET + " ";
    }

    public String enabledColored(boolean enabled) {
        return enabled ? C_REQ + "enabled" : C_ERR + "disabled";
    }

    public String nameEmphasized() {
        return this.commandEmphasized(this.name);
    }

    public String nameEmphasizedW() {
        return "{world} " + this.nameEmphasized();
    }

    public void sendCmdHelp(ICommandSender sender) {
        for (String example : sender instanceof EntityPlayerMP ? this.cmdExamplePlayer : this.cmdExampleConsole) {
            Util.chat(sender, example, new Object[0]);
        }
        this.cmdStatus(sender);
        if (this.helpText != null && !this.helpText.isEmpty()) {
            Util.chat(sender, C_DESC + this.helpText, new Object[0]);
        }
    }

    public void sendErrorAndHelp(ICommandSender sender, String error) {
        Util.chat(sender, C_ERR + error, new Object[0]);
        this.sendCmdHelp(sender);
    }

    public boolean strAsBool(String str) {
        return (str = str.toLowerCase()).startsWith("y") || str.startsWith("t") || str.startsWith("on") || str.startsWith("+") || str.startsWith("1");
    }
}

