/*
 * Decompiled with CFR 0.152.
 */
package com.wimbli.WorldBorder.listener;

import com.wimbli.WorldBorder.BorderData;
import com.wimbli.WorldBorder.Config;
import com.wimbli.WorldBorder.forge.Worlds;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MobSpawnListener {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onCreatureSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (this.isInsideBorder((LivingSpawnEvent)event)) {
            return;
        }
        event.setResult(Event.Result.DENY);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (this.isInsideBorder((LivingSpawnEvent)event)) {
            return;
        }
        event.setCanceled(true);
    }

    private boolean isInsideBorder(LivingSpawnEvent event) {
        World world = event.getEntity().field_70170_p;
        BorderData border = Config.Border(Worlds.getWorldName(world));
        return border == null || border.insideBorder(event.getEntity().field_70165_t, event.getEntity().field_70161_v, Config.getShapeRound());
    }
}

