/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.renderer;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import li.cil.scannable.client.ScanManager;
import li.cil.scannable.common.Scannable;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.integration.optifine.ProxyOptiFine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

@SideOnly(value=Side.CLIENT)
public enum ScannerRenderer {
    INSTANCE;

    private static final ResourceLocation SCANNER_VERTEX_SHADER_LOCATION;
    private static final ResourceLocation SCANNER_FRAGMENT_SHADER_LOCATION;
    private static final ResourceLocation COPY_VERTEX_SHADER_LOCATION;
    private static final ResourceLocation COPY_FRAGMENT_SHADER_LOCATION;
    private int vertexShader;
    private int fragmentShader;
    private int shaderProgram;
    private int camPosUniform;
    private int centerUniform;
    private int radiusUniform;
    private int zNearUniform;
    private int zFarUniform;
    private int aspectUniform;
    private int copyVertexShader;
    private int copyFragmentShader;
    private int copyShaderProgram;
    private Mode mode;
    private int framebufferObject;
    private int framebufferDepthTexture;
    private int copyFramebufferObject;
    private int copyFramebufferDepthTexture;
    private final FloatBuffer float1Buffer = BufferUtils.createFloatBuffer((int)1);
    private final FloatBuffer float3Buffer = BufferUtils.createFloatBuffer((int)3);
    private final FloatBuffer float16Buffer = BufferUtils.createFloatBuffer((int)16);
    private final Matrix4f projectionMatrix = new Matrix4f();
    private final Matrix4f modelViewMatrix = new Matrix4f();
    private final Matrix4f mvpMatrix = new Matrix4f();
    private final Vector4f tempCorner = new Vector4f();
    private final Vector3f topLeft = new Vector3f();
    private final Vector3f topRight = new Vector3f();
    private final Vector3f bottomLeft = new Vector3f();
    private final Vector3f bottomRight = new Vector3f();
    public static final Vector4f CORNER_TOP_LEFT;
    public static final Vector4f CORNER_TOP_RIGHT;
    public static final Vector4f CORNER_BOTTOM_LEFT;
    public static final Vector4f CORNER_BOTTOM_RIGHT;
    private long currentStart = -1L;

    public void init() {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        this.reloadShaders(resourceManager);
        if (resourceManager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)resourceManager).func_110542_a(this::reloadShaders);
        }
    }

    private void reloadShaders(IResourceManager resourceManager) {
        try {
            this.deleteShader();
            this.vertexShader = ScannerRenderer.loadShader(resourceManager, 35633, SCANNER_VERTEX_SHADER_LOCATION);
            this.fragmentShader = ScannerRenderer.loadShader(resourceManager, 35632, SCANNER_FRAGMENT_SHADER_LOCATION);
            this.shaderProgram = ScannerRenderer.linkProgram(this.vertexShader, this.fragmentShader);
            this.camPosUniform = OpenGlHelper.func_153194_a((int)this.shaderProgram, (CharSequence)"camPos");
            this.centerUniform = OpenGlHelper.func_153194_a((int)this.shaderProgram, (CharSequence)"center");
            this.radiusUniform = OpenGlHelper.func_153194_a((int)this.shaderProgram, (CharSequence)"radius");
            this.zNearUniform = OpenGlHelper.func_153194_a((int)this.shaderProgram, (CharSequence)"zNear");
            this.zFarUniform = OpenGlHelper.func_153194_a((int)this.shaderProgram, (CharSequence)"zFar");
            this.aspectUniform = OpenGlHelper.func_153194_a((int)this.shaderProgram, (CharSequence)"aspect");
            this.copyVertexShader = ScannerRenderer.loadShader(resourceManager, 35633, COPY_VERTEX_SHADER_LOCATION);
            this.copyFragmentShader = ScannerRenderer.loadShader(resourceManager, 35632, COPY_FRAGMENT_SHADER_LOCATION);
            this.copyShaderProgram = ScannerRenderer.linkProgram(this.copyVertexShader, this.copyFragmentShader);
        }
        catch (Exception e) {
            this.deleteShader();
            Scannable.getLog().error("Failed loading shader.", (Throwable)e);
        }
    }

    public void ping(Vec3d pos) {
        if (this.shaderProgram == 0) {
            return;
        }
        if (!OpenGlHelper.func_148822_b()) {
            return;
        }
        this.currentStart = System.currentTimeMillis();
        OpenGlHelper.func_153161_d((int)this.shaderProgram);
        Minecraft mc = Minecraft.func_71410_x();
        Framebuffer framebuffer = mc.func_147110_a();
        this.setUniform(this.aspectUniform, (float)framebuffer.field_147622_a / (float)framebuffer.field_147620_b);
        this.setUniform(this.zNearUniform, 0.05f);
        this.setUniform(this.zFarUniform, mc.field_71474_y.field_151451_c * 16);
        this.setUniform(this.centerUniform, pos);
        OpenGlHelper.func_153161_d((int)0);
    }

    @SubscribeEvent
    public void onPreWorldRender(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.preRender();
        }
    }

    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        boolean isRenderingEffect;
        boolean bl = isRenderingEffect = this.framebufferDepthTexture != 0;
        if (isRenderingEffect) {
            boolean isUsingShaders = ProxyOptiFine.INSTANCE.isShaderPackLoaded();
            if (isUsingShaders) {
                this.copyDepthTexture();
            } else {
                this.render(event.getPartialTicks());
            }
        }
    }

    @SubscribeEvent
    public void onPreRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        boolean isUsingShaders;
        boolean isRenderingEffect;
        boolean bl = isRenderingEffect = this.framebufferDepthTexture != 0;
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && isRenderingEffect && (isUsingShaders = ProxyOptiFine.INSTANCE.isShaderPackLoaded())) {
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179094_E();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179094_E();
            Minecraft.func_71410_x().field_71460_t.func_78479_a(event.getPartialTicks(), 2);
            this.render(event.getPartialTicks());
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179121_F();
        }
    }

    private void preRender() {
        if (this.currentStart < 0L) {
            return;
        }
        if (this.shaderProgram == 0) {
            return;
        }
        if (!OpenGlHelper.func_148822_b()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        if (world == null) {
            return;
        }
        if (ProxyOptiFine.INSTANCE.isShaderPackLoaded()) {
            this.mode = Mode.OPTIFINE;
        } else if (this.mode == Mode.OPTIFINE || this.mode == null) {
            this.mode = Settings.injectDepthTexture ? Mode.INJECT : Mode.RENDER;
        }
        Framebuffer framebuffer = mc.func_147110_a();
        int adjustedDuration = ScanManager.computeScanGrowthDuration();
        if (this.framebufferDepthTexture == 0) {
            if (adjustedDuration > (int)(System.currentTimeMillis() - this.currentStart)) {
                this.installDepthTexture(framebuffer);
            }
        } else if (adjustedDuration < (int)(System.currentTimeMillis() - this.currentStart)) {
            this.uninstallDepthTexture(framebuffer);
            this.currentStart = -1L;
        } else if (this.mode == Mode.INJECT && GL11.glGetError() != 0) {
            Scannable.getLog().info("Huh, looks like our injected depth texture broke something maybe? Falling back to re-rendering.");
            this.uninstallDepthTexture(framebuffer);
            this.mode = Mode.RENDER;
            this.installDepthTexture(framebuffer);
        }
    }

    private void copyDepthTexture() {
        Minecraft mc = Minecraft.func_71410_x();
        Framebuffer framebuffer = mc.func_147110_a();
        int oldFramebuffer = GlStateManager.func_187397_v((int)36006);
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.copyFramebufferObject);
        int width = framebuffer.field_147622_a;
        int height = framebuffer.field_147620_b;
        GlStateManager.func_179144_i((int)this.framebufferDepthTexture);
        int oldProgram = GlStateManager.func_187397_v((int)35725);
        OpenGlHelper.func_153161_d((int)this.copyShaderProgram);
        this.setupMatrices(width, height);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(0.0, (double)height, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)width, (double)height, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)width, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        this.restoreMatrices();
        OpenGlHelper.func_153161_d((int)oldProgram);
        GlStateManager.func_179144_i((int)0);
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)oldFramebuffer);
    }

    private void render(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        if (world == null) {
            return;
        }
        Entity viewer = mc.func_175606_aa();
        if (viewer == null) {
            return;
        }
        Framebuffer framebuffer = mc.func_147110_a();
        int adjustedDuration = ScanManager.computeScanGrowthDuration();
        if (this.mode == Mode.RENDER) {
            int oldFramebuffer = GlStateManager.func_187397_v((int)36006);
            OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.framebufferObject);
            GlStateManager.func_179086_m((int)256);
            GlStateManager.func_179090_x();
            mc.field_71438_f.func_174977_a(BlockRenderLayer.SOLID, (double)partialTicks, 0, viewer);
            mc.field_71438_f.func_174977_a(BlockRenderLayer.CUTOUT_MIPPED, (double)partialTicks, 0, viewer);
            GlStateManager.func_179098_w();
            OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)oldFramebuffer);
        }
        this.setupCorners();
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        int width = framebuffer.field_147622_a;
        int height = framebuffer.field_147620_b;
        float radius = ScanManager.computeRadius(this.currentStart, adjustedDuration);
        if (this.copyFramebufferDepthTexture != 0) {
            GlStateManager.func_179144_i((int)this.copyFramebufferDepthTexture);
        } else {
            if (this.mode == Mode.INJECT) {
                if (framebuffer.isStencilEnabled()) {
                    OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)36096, (int)OpenGlHelper.field_153199_f, (int)framebuffer.field_147624_h);
                    OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)36128, (int)OpenGlHelper.field_153199_f, (int)framebuffer.field_147624_h);
                } else {
                    OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153201_h, (int)OpenGlHelper.field_153199_f, (int)framebuffer.field_147624_h);
                }
            }
            GlStateManager.func_179144_i((int)this.framebufferDepthTexture);
        }
        int oldProgram = GlStateManager.func_187397_v((int)35725);
        OpenGlHelper.func_153161_d((int)this.shaderProgram);
        this.setUniform(this.camPosUniform, viewer.func_174824_e(partialTicks));
        this.setUniform(this.radiusUniform, radius);
        this.setupMatrices(width, height);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        buffer.func_181662_b(0.0, (double)height, 0.0).func_187315_a(0.0, 0.0).func_181663_c(this.bottomLeft.x, this.bottomLeft.y, this.bottomLeft.z).func_181675_d();
        buffer.func_181662_b((double)width, (double)height, 0.0).func_187315_a(1.0, 0.0).func_181663_c(this.bottomRight.x, this.bottomRight.y, this.bottomRight.z).func_181675_d();
        buffer.func_181662_b((double)width, 0.0, 0.0).func_187315_a(1.0, 1.0).func_181663_c(this.topRight.x, this.topRight.y, this.topRight.z).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, 1.0).func_181663_c(this.topLeft.x, this.topLeft.y, this.topLeft.z).func_181675_d();
        tessellator.func_78381_a();
        this.restoreMatrices();
        OpenGlHelper.func_153161_d((int)oldProgram);
        GlStateManager.func_179144_i((int)0);
        if (this.mode == Mode.INJECT && this.copyFramebufferDepthTexture == 0) {
            if (framebuffer.isStencilEnabled()) {
                OpenGlHelper.func_153188_a((int)OpenGlHelper.field_153198_e, (int)33306, (int)3553, (int)this.framebufferDepthTexture, (int)0);
            } else {
                OpenGlHelper.func_153188_a((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153201_h, (int)3553, (int)this.framebufferDepthTexture, (int)0);
            }
        }
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    private static int loadShader(IResourceManager resourceManager, int type, ResourceLocation location) throws Exception {
        int shader = OpenGlHelper.func_153195_b((int)type);
        ScannerRenderer.compileShader(resourceManager, shader, location);
        return shader;
    }

    private static void compileShader(IResourceManager resourceManager, int shader, ResourceLocation location) throws Exception {
        IResource resource = resourceManager.func_110536_a(location);
        try (InputStream stream = resource.func_110527_b();){
            byte[] bytes = IOUtils.toByteArray((InputStream)stream);
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)bytes.length);
            buffer.put(bytes);
            buffer.rewind();
            OpenGlHelper.func_153169_a((int)shader, (ByteBuffer)buffer);
        }
        OpenGlHelper.func_153170_c((int)shader);
        if (OpenGlHelper.func_153157_c((int)shader, (int)35713) == 0) {
            throw new Exception(OpenGlHelper.func_153158_d((int)shader, (int)4096));
        }
    }

    private static int linkProgram(int vertexShader, int fragmentShader) throws Exception {
        int program = OpenGlHelper.func_153183_d();
        if (vertexShader > 0) {
            OpenGlHelper.func_153178_b((int)program, (int)vertexShader);
        }
        OpenGlHelper.func_153178_b((int)program, (int)fragmentShader);
        OpenGlHelper.func_153179_f((int)program);
        if (OpenGlHelper.func_153175_a((int)program, (int)35714) == 0) {
            throw new Exception(OpenGlHelper.func_153166_e((int)program, (int)4096));
        }
        return program;
    }

    private void deleteShader() {
        if (this.shaderProgram != 0) {
            OpenGlHelper.func_153187_e((int)this.shaderProgram);
            this.shaderProgram = 0;
        }
        if (this.vertexShader != 0) {
            OpenGlHelper.func_153180_a((int)this.vertexShader);
            this.vertexShader = 0;
        }
        if (this.fragmentShader != 0) {
            OpenGlHelper.func_153180_a((int)this.fragmentShader);
            this.fragmentShader = 0;
        }
        if (this.copyShaderProgram != 0) {
            OpenGlHelper.func_153187_e((int)this.copyShaderProgram);
            this.copyShaderProgram = 0;
        }
        if (this.copyVertexShader != 0) {
            OpenGlHelper.func_153180_a((int)this.copyVertexShader);
            this.copyVertexShader = 0;
        }
        if (this.copyFragmentShader != 0) {
            OpenGlHelper.func_153180_a((int)this.copyFragmentShader);
            this.copyFragmentShader = 0;
        }
    }

    private void installDepthTexture(Framebuffer framebuffer) {
        int oldFramebuffer = GlStateManager.func_187397_v((int)36006);
        switch (this.mode) {
            case INJECT: {
                this.framebufferObject = framebuffer.field_147616_f;
                if (framebuffer.isStencilEnabled()) {
                    this.framebufferDepthTexture = this.createTexture(framebuffer.field_147622_a, framebuffer.field_147620_b, 35056, 34041, 34042);
                    OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.framebufferObject);
                    OpenGlHelper.func_153188_a((int)OpenGlHelper.field_153198_e, (int)33306, (int)3553, (int)this.framebufferDepthTexture, (int)0);
                    break;
                }
                this.framebufferDepthTexture = this.createTexture(framebuffer.field_147622_a, framebuffer.field_147620_b, 33190, 6402, 5125);
                OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.framebufferObject);
                OpenGlHelper.func_153188_a((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153201_h, (int)3553, (int)this.framebufferDepthTexture, (int)0);
                break;
            }
            case RENDER: {
                this.framebufferObject = OpenGlHelper.func_153165_e();
                this.framebufferDepthTexture = this.createTexture(framebuffer.field_147622_a, framebuffer.field_147620_b, 33190, 6402, 5125);
                OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.framebufferObject);
                OpenGlHelper.func_153188_a((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153201_h, (int)3553, (int)this.framebufferDepthTexture, (int)0);
                break;
            }
            case OPTIFINE: {
                this.framebufferDepthTexture = ProxyOptiFine.INSTANCE.getDepthTexture();
                this.copyFramebufferObject = OpenGlHelper.func_153165_e();
                this.copyFramebufferDepthTexture = this.createTexture(framebuffer.field_147622_a, framebuffer.field_147620_b, 33326, 6403, 5121);
                OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.copyFramebufferObject);
                OpenGlHelper.func_153188_a((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153200_g, (int)3553, (int)this.copyFramebufferDepthTexture, (int)0);
            }
        }
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)oldFramebuffer);
    }

    private void uninstallDepthTexture(Framebuffer framebuffer) {
        switch (this.mode) {
            case INJECT: {
                if (framebuffer.isStencilEnabled()) {
                    OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.framebufferObject);
                    OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)36096, (int)OpenGlHelper.field_153199_f, (int)framebuffer.field_147624_h);
                    OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)36128, (int)OpenGlHelper.field_153199_f, (int)framebuffer.field_147624_h);
                } else {
                    OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.framebufferObject);
                    OpenGlHelper.func_153190_b((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153201_h, (int)OpenGlHelper.field_153199_f, (int)framebuffer.field_147624_h);
                }
                TextureUtil.func_147942_a((int)this.framebufferDepthTexture);
                break;
            }
            case RENDER: {
                OpenGlHelper.func_153174_h((int)this.framebufferObject);
                TextureUtil.func_147942_a((int)this.framebufferDepthTexture);
                break;
            }
            case OPTIFINE: {
                OpenGlHelper.func_153174_h((int)this.copyFramebufferObject);
                TextureUtil.func_147942_a((int)this.copyFramebufferDepthTexture);
            }
        }
        this.framebufferObject = 0;
        this.framebufferDepthTexture = 0;
        this.copyFramebufferObject = 0;
        this.copyFramebufferDepthTexture = 0;
    }

    private int createTexture(int width, int height, int internalFormat, int format, int type) {
        int texture = TextureUtil.func_110996_a();
        GlStateManager.func_179144_i((int)texture);
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
        GlStateManager.func_187421_b((int)3553, (int)34891, (int)6409);
        GlStateManager.func_187421_b((int)3553, (int)34893, (int)515);
        GlStateManager.func_187419_a((int)3553, (int)0, (int)internalFormat, (int)width, (int)height, (int)0, (int)format, (int)type, null);
        GlStateManager.func_179144_i((int)0);
        return texture;
    }

    private void setupCorners() {
        this.getMatrix(2983, this.projectionMatrix);
        this.getMatrix(2982, this.modelViewMatrix);
        Matrix4f.mul((Matrix4f)this.projectionMatrix, (Matrix4f)this.modelViewMatrix, (Matrix4f)this.mvpMatrix);
        this.mvpMatrix.invert();
        this.setupCorner(CORNER_TOP_LEFT, this.topLeft);
        this.setupCorner(CORNER_TOP_RIGHT, this.topRight);
        this.setupCorner(CORNER_BOTTOM_LEFT, this.bottomLeft);
        this.setupCorner(CORNER_BOTTOM_RIGHT, this.bottomRight);
    }

    private void setupCorner(Vector4f corner, Vector3f into) {
        Matrix4f.transform((Matrix4f)this.mvpMatrix, (Vector4f)corner, (Vector4f)this.tempCorner);
        this.tempCorner.scale(1.0f / this.tempCorner.w);
        into.set((ReadableVector3f)this.tempCorner);
        into.normalise();
    }

    private void setupMatrices(int width, int height) {
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)width, (double)height, (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        GlStateManager.func_179083_b((int)0, (int)0, (int)width, (int)height);
    }

    private void restoreMatrices() {
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
    }

    private void getMatrix(int matrix, Matrix4f into) {
        this.float16Buffer.position(0);
        GlStateManager.func_179111_a((int)matrix, (FloatBuffer)this.float16Buffer);
        this.float16Buffer.position(0);
        into.load(this.float16Buffer);
    }

    private void setUniform(int uniform, float value) {
        this.float1Buffer.clear();
        this.float1Buffer.put(value);
        this.float1Buffer.rewind();
        OpenGlHelper.func_153168_a((int)uniform, (FloatBuffer)this.float1Buffer);
    }

    private void setUniform(int uniform, Vec3d value) {
        this.float3Buffer.clear();
        this.float3Buffer.put((float)value.field_72450_a);
        this.float3Buffer.put((float)value.field_72448_b);
        this.float3Buffer.put((float)value.field_72449_c);
        this.float3Buffer.rewind();
        OpenGlHelper.func_153191_c((int)uniform, (FloatBuffer)this.float3Buffer);
    }

    static {
        SCANNER_VERTEX_SHADER_LOCATION = new ResourceLocation("scannable", "shaders/scanner.vsh");
        SCANNER_FRAGMENT_SHADER_LOCATION = new ResourceLocation("scannable", "shaders/scanner.fsh");
        COPY_VERTEX_SHADER_LOCATION = new ResourceLocation("scannable", "shaders/copy.vsh");
        COPY_FRAGMENT_SHADER_LOCATION = new ResourceLocation("scannable", "shaders/copy.fsh");
        CORNER_TOP_LEFT = new Vector4f(-1.0f, 1.0f, 1.0f, 1.0f);
        CORNER_TOP_RIGHT = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        CORNER_BOTTOM_LEFT = new Vector4f(-1.0f, -1.0f, 1.0f, 1.0f);
        CORNER_BOTTOM_RIGHT = new Vector4f(1.0f, -1.0f, 1.0f, 1.0f);
    }

    private static enum Mode {
        INJECT,
        RENDER,
        OPTIFINE;

    }
}

