/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import java.util.List;
import javax.annotation.Nullable;
import li.cil.scannable.common.capabilities.CapabilityProviderModuleStructure;
import li.cil.scannable.common.init.Items;
import li.cil.scannable.common.item.AbstractItemScannerModule;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ItemScannerModuleStructure
extends AbstractItemScannerModule {
    private static final String TAG_HIDE_EXPLORED = "hideExplored";

    public static boolean hideExplored(ItemStack stack) {
        if (!Items.isModuleStructure(stack)) {
            return false;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74767_n(TAG_HIDE_EXPLORED);
    }

    private static void setHideExplored(ItemStack stack, boolean hideExplored) {
        NBTTagCompound nbt;
        if (!stack.func_77942_o()) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        } else {
            nbt = stack.func_77978_p();
        }
        assert (nbt != null);
        nbt.func_74757_a(TAG_HIDE_EXPLORED, hideExplored);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return CapabilityProviderModuleStructure.INSTANCE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)"tooltip.scannable.module_structure", (Object[])new Object[0]));
        if (ItemScannerModuleStructure.hideExplored(stack)) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.scannable.module_structure.hide_explored", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.scannable.module_structure.show_explored", (Object[])new Object[0]));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        ItemScannerModuleStructure.setHideExplored(stack, !ItemScannerModuleStructure.hideExplored(stack));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

