/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.tile.TileEntityParaChest;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class EntityParachest
extends Entity
implements IPacketReceiver {
    public NonNullList<ItemStack> cargo;
    public int fuelLevel;
    private boolean placedChest;
    public EnumDyeColor color = EnumDyeColor.WHITE;

    public EntityParachest(World world, NonNullList<ItemStack> cargo, int fuelLevel) {
        this(world);
        this.cargo = NonNullList.func_191197_a((int)cargo.size(), (Object)ItemStack.field_190927_a);
        Collections.copy(this.cargo, cargo);
        this.placedChest = false;
        this.fuelLevel = fuelLevel;
    }

    public EntityParachest(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        int size = 56;
        if (nbt.func_74764_b("CargoLength")) {
            size = nbt.func_74762_e("CargoLength");
        }
        this.cargo = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.cargo);
        this.placedChest = nbt.func_74767_n("placedChest");
        this.fuelLevel = nbt.func_74762_e("FuelLevel");
        if (nbt.func_74764_b("color")) {
            this.color = EnumDyeColor.func_176766_a((int)nbt.func_74762_e("color"));
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        nbt.func_74768_a("CargoLength", this.cargo.size());
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.cargo);
        nbt.func_74757_a("placedChest", this.placedChest);
        nbt.func_74768_a("FuelLevel", this.fuelLevel);
        nbt.func_74768_a("color", this.color.func_176767_b());
    }

    public void func_70071_h_() {
        if (!this.placedChest) {
            if (this.field_70122_E && !this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 100; ++i) {
                    int z;
                    int y;
                    int x = MathHelper.func_76128_c((double)this.field_70165_t);
                    BlockPos pos = new BlockPos(x, (y = MathHelper.func_76128_c((double)this.field_70163_u)) + i, z = MathHelper.func_76128_c((double)this.field_70161_v));
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (!block.func_149688_o(state).func_76222_j()) continue;
                    if (this.placeChest(pos)) {
                        this.func_70106_y();
                        return;
                    }
                    if (this.cargo == null) continue;
                    for (ItemStack stack : this.cargo) {
                        EntityItem e = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
                        this.field_70170_p.func_72838_d((Entity)e);
                    }
                    return;
                }
                if (this.cargo != null) {
                    for (ItemStack stack : this.cargo) {
                        EntityItem e = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
                        this.field_70170_p.func_72838_d((Entity)e);
                    }
                }
            } else {
                this.field_70181_x = -0.35;
            }
            this.func_70091_d(MoverType.SELF, 0.0, this.field_70181_x, 0.0);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 5 == 0) {
            GalacticraftCore.packetPipeline.sendToAllAround(new PacketDynamic(this), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(this.field_70170_p), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
    }

    private boolean placeChest(BlockPos pos) {
        this.field_70170_p.func_180501_a(pos, GCBlocks.parachest.func_176223_P(), 3);
        TileEntity te = this.field_70170_p.func_175625_s(pos);
        if (te instanceof TileEntityParaChest && this.cargo != null) {
            TileEntityParaChest chest = (TileEntityParaChest)te;
            chest.inventory = NonNullList.func_191197_a((int)(this.cargo.size() + 1), (Object)ItemStack.field_190927_a);
            chest.color = this.color;
            Collections.copy(chest.getInventory(), this.cargo);
            chest.fuelTank.fill(FluidRegistry.getFluidStack((String)GCFluids.fluidFuel.getName().toLowerCase(), (int)this.fuelLevel), true);
            return true;
        }
        this.placedChest = true;
        return true;
    }

    @Override
    public void getNetworkedData(ArrayList<Object> sendData) {
        if (!this.field_70170_p.field_72995_K) {
            sendData.add(this.color.func_176767_b());
        }
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        if (this.field_70170_p.field_72995_K) {
            this.color = EnumDyeColor.func_176766_a((int)buffer.readInt());
        }
    }
}

