/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.EnumSet;
import micdoodle8.mods.galacticraft.core.blocks.BlockOxygenCompressor;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterOxygenInfinite;
import micdoodle8.mods.galacticraft.core.items.ItemOxygenTank;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygen;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;

public class TileEntityOxygenDecompressor
extends TileEntityOxygen
implements IInventoryDefaults,
ISidedInventory {
    public static final int OUTPUT_PER_TICK = 100;
    private boolean usingEnergy = false;

    public TileEntityOxygenDecompressor() {
        super("container.oxygendecompressor.name", 1200, 0);
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.usingEnergy = false;
            ItemStack tank1 = (ItemStack)this.getInventory().get(0);
            if (!tank1.func_190926_b() && this.hasEnoughEnergyToRun && this.getOxygenStored() < this.getMaxOxygenStored()) {
                if (tank1.func_77973_b() instanceof ItemOxygenTank && tank1.func_77952_i() < tank1.func_77958_k()) {
                    tank1.func_77964_b(tank1.func_77952_i() + 1);
                    this.receiveOxygen(1, true);
                    this.usingEnergy = true;
                } else if (tank1.func_77973_b() instanceof ItemCanisterOxygenInfinite) {
                    this.receiveOxygen(1, true);
                    this.usingEnergy = true;
                }
            }
            this.produceOxygen();
        }
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    @Override
    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return itemstack.func_77952_i() < itemstack.func_77958_k();
                }
                case 1: {
                    return ItemElectricBase.isElectricItemCharged(itemstack);
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return itemstack.func_77952_i() == itemstack.func_77958_k();
                }
                case 1: {
                    return ItemElectricBase.isElectricItemEmpty(itemstack);
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return itemstack.func_77973_b() instanceof ItemOxygenTank;
            }
            case 1: {
                return ItemElectricBase.isElectricItem(itemstack.func_77973_b());
            }
        }
        return false;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.usingEnergy;
    }

    @Override
    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockOxygenCompressor) {
            return ((EnumFacing)state.func_177229_b((IProperty)BlockOxygenCompressor.FACING)).func_176746_e();
        }
        return EnumFacing.NORTH;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        return this.getFront();
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(1);
    }

    public EnumFacing getOxygenOutputDirection() {
        return this.getElectricInputDirection().func_176734_d();
    }

    @Override
    public EnumSet<EnumFacing> getOxygenInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    @Override
    public EnumSet<EnumFacing> getOxygenOutputDirections() {
        return EnumSet.of(this.getElectricInputDirection().func_176734_d());
    }

    @Override
    public boolean shouldPullOxygen() {
        return false;
    }

    @Override
    public boolean shouldUseOxygen() {
        return false;
    }

    @Override
    public int getOxygenProvide(EnumFacing direction) {
        return this.getOxygenOutputDirections().contains(direction) ? Math.min(100, this.getOxygenStored()) : 0;
    }
}

