/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.ae2wtlib.items;

import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.storage.IStorageChannel;
import appeng.api.util.IConfigManager;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;
import p455w0rd.ae2wtlib.AE2WTLib;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.api.item.ItemWT;
import p455w0rd.ae2wtlib.helpers.IWirelessUniversalItem;
import p455w0rd.ae2wtlib.init.LibItems;
import p455w0rd.ae2wtlib.init.LibRecipes;

public class ItemWUT
extends ItemWT
implements IWirelessUniversalItem {
    private static final String STOREDTERMINALS_KEY = "StoredTerminals";
    private static final String SELECTEDTERMINAL_KEY = "SelectedTerminal";
    private ICustomWirelessTerminalItem selectedTerminal;

    public ItemWUT() {
        super(new ResourceLocation("ae2wtlib", "wut"));
    }

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack wut, World world, List<String> list, ITooltipFlag advancedTooltips) {
        ItemStack selectedTerminal = (ItemStack)ItemWUT.getSelectedTerminalStack(wut).getLeft();
        String title = list.get(0);
        list.clear();
        if (!title.isEmpty()) {
            list.add(title);
        }
        if (!selectedTerminal.func_190926_b()) {
            List<Pair<ItemStack, Integer>> installedTerminals;
            list.add(TextFormatting.WHITE + "" + TextFormatting.ITALIC + "" + selectedTerminal.func_82833_r());
            if (((ICustomWirelessTerminalItem)selectedTerminal.func_77973_b()).getPlayer() == null && this.getPlayer() != null) {
                ((ICustomWirelessTerminalItem)selectedTerminal.func_77973_b()).setPlayer(this.getPlayer());
            }
            if (!(installedTerminals = WTApi.instance().getWUTUtility().getStoredTerminals(wut)).isEmpty()) {
                list.add(1, TextFormatting.UNDERLINE + "      Installed Modules      ");
                if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
                    list.add(2, "Press Shift");
                } else {
                    for (int i = 0; i < installedTerminals.size(); ++i) {
                        String underline = i == installedTerminals.size() - 1 ? TextFormatting.UNDERLINE.toString() : "";
                        list.add(2 + i, TextFormatting.ITALIC + "" + underline + " " + ((ItemStack)installedTerminals.get(i).getLeft()).func_82833_r());
                    }
                }
            }
            ((AEBasePoweredItem)selectedTerminal.func_77973_b()).addCheckedInformation(wut, world, list, advancedTooltips);
        }
    }

    @Override
    public IConfigManager getConfigManager(ItemStack wut) {
        ItemStack selectedTerminal = (ItemStack)ItemWUT.getSelectedTerminalStack(wut).getLeft();
        if (!selectedTerminal.func_190926_b()) {
            return ((IWirelessTermHandler)selectedTerminal.func_77973_b()).getConfigManager(wut);
        }
        return null;
    }

    @Override
    public IStorageChannel<?> getStorageChannel(ItemStack wut) {
        ItemStack selectedStack = (ItemStack)ItemWUT.getSelectedTerminalStack(wut).getLeft();
        if (!selectedStack.func_190926_b()) {
            return ((ICustomWirelessTerminalItem)selectedStack.func_77973_b()).getStorageChannel(selectedStack);
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND && !item.func_190926_b() && this.getAECurrentPower(item) > 0.0) {
            if (!player.func_70093_af()) {
                if (world.field_72995_K) {
                    this.openGui(player, false, player.field_71071_by.field_70461_c);
                }
            } else if (world.field_72995_K) {
                player.openGui((Object)AE2WTLib.INSTANCE, 0, world, 0, 0, 0);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
    }

    @Override
    public void openGui(EntityPlayer player, boolean isBauble, int playerSlot) {
        ICustomWirelessTerminalItem terminalItem;
        Pair<ICustomWirelessTerminalItem, Integer> handler;
        ItemStack heldStack = player.field_71071_by.func_70448_g();
        if (heldStack.func_77973_b() instanceof ItemWUT && (handler = ItemWUT.getSelectedTerminalHandler(heldStack)) != null && (terminalItem = (ICustomWirelessTerminalItem)handler.getLeft()) != null) {
            terminalItem.openGui(player, isBauble, playerSlot);
        }
    }

    public static List<Pair<ICustomWirelessTerminalItem, Integer>> getStoredTerminalHandlers(ItemStack wut) {
        List<Pair<ItemStack, Integer>> t = ItemWUT.getStoredTerminalStacks(wut);
        ArrayList<Pair<ICustomWirelessTerminalItem, Integer>> c = new ArrayList<Pair<ICustomWirelessTerminalItem, Integer>>();
        for (Pair<ItemStack, Integer> tPair : t) {
            if (!(((ItemStack)tPair.getLeft()).func_77973_b() instanceof ICustomWirelessTerminalItem)) continue;
            c.add((Pair<ICustomWirelessTerminalItem, Integer>)Pair.of((Object)((ICustomWirelessTerminalItem)((ItemStack)tPair.getLeft()).func_77973_b()), (Object)tPair.getRight()));
        }
        return c;
    }

    public static List<Pair<ItemStack, Integer>> getStoredTerminalStacks(ItemStack wut) {
        NBTTagList terminalList;
        if (wut.func_77942_o() && wut.func_77978_p().func_150297_b(STOREDTERMINALS_KEY, 9) && (terminalList = wut.func_77978_p().func_150295_c(STOREDTERMINALS_KEY, 10)).func_74745_c() > 0) {
            ArrayList<Pair<ItemStack, Integer>> returnList = new ArrayList<Pair<ItemStack, Integer>>();
            for (int i = 0; i < terminalList.func_74745_c(); ++i) {
                ItemStack newStack = new ItemStack(terminalList.func_150305_b(i));
                if (newStack.func_77942_o()) {
                    newStack.func_77982_d(null);
                }
                returnList.add((Pair<ItemStack, Integer>)Pair.of((Object)newStack, (Object)i));
            }
            return returnList;
        }
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)ItemStack.field_190927_a, (Object)-1)});
    }

    public static Pair<ItemStack, Integer> getSelectedTerminalStack(ItemStack wut) {
        int index;
        List<Pair<ItemStack, Integer>> terminals = ItemWUT.getStoredTerminalStacks(wut);
        if (terminals.size() > 0 && wut.func_77942_o() && wut.func_77978_p().func_150297_b(SELECTEDTERMINAL_KEY, 3) && (index = wut.func_77978_p().func_74762_e(SELECTEDTERMINAL_KEY)) < terminals.size()) {
            return terminals.get(index);
        }
        return Pair.of((Object)ItemStack.field_190927_a, (Object)-1);
    }

    public static Pair<ICustomWirelessTerminalItem, Integer> getSelectedTerminalHandler(ItemStack wut) {
        int index;
        List<Pair<ICustomWirelessTerminalItem, Integer>> terminals = ItemWUT.getStoredTerminalHandlers(wut);
        if (terminals.size() > 0 && wut.func_77942_o() && wut.func_77978_p().func_150297_b(SELECTEDTERMINAL_KEY, 3) && (index = wut.func_77978_p().func_74762_e(SELECTEDTERMINAL_KEY)) < terminals.size()) {
            return Pair.of((Object)terminals.get(index).getLeft(), (Object)index);
        }
        return null;
    }

    public static void setSelectedTerminal(ItemStack wut, int index) {
        List<Pair<ICustomWirelessTerminalItem, Integer>> storedTerminals;
        if (!wut.func_77942_o()) {
            wut.func_77982_d(new NBTTagCompound());
        }
        if ((storedTerminals = ItemWUT.getStoredTerminalHandlers(wut)).size() > 0 && index < storedTerminals.size()) {
            wut.func_77978_p().func_74768_a(SELECTEDTERMINAL_KEY, index);
            return;
        }
        wut.func_77978_p().func_74768_a(SELECTEDTERMINAL_KEY, -1);
    }

    public static ItemStack getStoredTerminalByIndex(ItemStack wut, int index) {
        List<Pair<ItemStack, Integer>> storedList = ItemWUT.getStoredTerminalStacks(wut);
        if (index < storedList.size()) {
            return (ItemStack)storedList.get(index).getLeft();
        }
        return ItemStack.field_190927_a;
    }

    public static void cycleSelectedTerminal(ItemStack wut) {
        ItemWUT.cycleSelectedTerminal(wut, false);
    }

    public static void cycleSelectedTerminal(ItemStack wut, boolean reverse) {
        List<Pair<ICustomWirelessTerminalItem, Integer>> storedList = ItemWUT.getStoredTerminalHandlers(wut);
        if (storedList.size() > 0) {
            if (storedList.size() == 2) {
                Pair<ICustomWirelessTerminalItem, Integer> currentSelection = ItemWUT.getSelectedTerminalHandler(wut);
                ItemWUT.setSelectedTerminal(wut, (Integer)currentSelection.getRight() == 0 ? 1 : 0);
                return;
            }
            Pair<ICustomWirelessTerminalItem, Integer> currentSelection = ItemWUT.getSelectedTerminalHandler(wut);
            if (currentSelection != null) {
                ItemWUT.setSelectedTerminal(wut, !reverse ? ItemWUT.getPreviousIndex(wut) : ItemWUT.getNextIndex(wut));
            }
        }
    }

    public static int getNextIndex(ItemStack wut) {
        Pair<ICustomWirelessTerminalItem, Integer> currentSelection = ItemWUT.getSelectedTerminalHandler(wut);
        if (currentSelection != null) {
            int previousIndex = 0;
            previousIndex = (Integer)currentSelection.getRight() - 1;
            if (previousIndex < 0) {
                previousIndex = ItemWUT.getStoredTerminalHandlers(wut).size() - 1;
            }
            return previousIndex;
        }
        return -1;
    }

    public static int getPreviousIndex(ItemStack wut) {
        Pair<ICustomWirelessTerminalItem, Integer> currentSelection = ItemWUT.getSelectedTerminalHandler(wut);
        if (currentSelection != null) {
            int nextIndex = 0;
            nextIndex = (Integer)currentSelection.getRight() + 1;
            if (nextIndex >= ItemWUT.getStoredTerminalHandlers(wut).size()) {
                nextIndex = 0;
            }
            return nextIndex;
        }
        return -1;
    }

    public static ItemStack addTerminal(ItemStack wut, ItemStack otherTerminal) {
        ItemStack newWut = wut.func_77946_l();
        NBTTagList nbtList = newWut.func_77978_p().func_150295_c(STOREDTERMINALS_KEY, 10);
        ItemStack emptyOtherTerm = otherTerminal.func_77946_l();
        emptyOtherTerm.func_77982_d(null);
        nbtList.func_74742_a((NBTBase)emptyOtherTerm.func_77955_b(new NBTTagCompound()));
        if (otherTerminal.func_77942_o()) {
            newWut.func_77978_p().func_179237_a(otherTerminal.func_77978_p());
        }
        IAEItemPowerStorage powerItem = (IAEItemPowerStorage)wut.func_77973_b();
        double maxPower = powerItem.getAEMaxPower(wut);
        double totalPower = powerItem.getAECurrentPower(wut);
        int infinityEnergy = WTApi.instance().getInfinityEnergy(wut);
        infinityEnergy = (infinityEnergy += WTApi.instance().getInfinityEnergy(otherTerminal)) > Integer.MAX_VALUE ? Integer.MAX_VALUE : infinityEnergy;
        double newPower = totalPower > maxPower ? maxPower : (totalPower += powerItem.getAECurrentPower(otherTerminal));
        newWut.func_77978_p().func_74780_a("internalCurrentPower", newPower);
        WTApi.instance().setInfinityEnergy(newWut, infinityEnergy);
        return newWut;
    }

    public static boolean isTypeInstalled(ItemStack wut, Class<?> type) {
        List<Pair<ItemStack, Integer>> storedStacks = ItemWUT.getStoredTerminalStacks(wut);
        if (wut.func_77973_b() == LibItems.ULTIMATE_TERMINAL && storedStacks.size() > 0) {
            for (Pair<ItemStack, Integer> currentStack : storedStacks) {
                Class<?> itemClass;
                List interfaces;
                if (((ItemStack)currentStack.getLeft()).func_190926_b() || !(interfaces = ClassUtils.getAllInterfaces(itemClass = ((ItemStack)currentStack.getLeft()).func_77973_b().getClass())).contains(type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTypeInstalled(ItemStack wut, Item type) {
        return Sets.newHashSet(ItemWUT.getStoredTerminalStacks(wut)).stream().map(Pair::getLeft).map(ItemStack::func_77973_b).anyMatch(type::equals);
    }

    public static List<ICustomWirelessTerminalItem> getIntegratableTypes() {
        ArrayList<ICustomWirelessTerminalItem> list = new ArrayList<ICustomWirelessTerminalItem>();
        for (ICustomWirelessTerminalItem iCustomWirelessTerminalItem : WTApi.instance().getWirelessTerminalRegistry().getRegisteredTerminals()) {
            if (LibRecipes.isCreative(new ItemStack((Item)iCustomWirelessTerminalItem)) || LibRecipes.isWut(new ItemStack((Item)iCustomWirelessTerminalItem))) continue;
            list.add(iCustomWirelessTerminalItem);
        }
        return list;
    }

    public static ItemStack createNewWUT(ItemStack terminalA, ItemStack terminalB) {
        if (terminalA.func_77973_b() instanceof ICustomWirelessTerminalItem && terminalB.func_77973_b() instanceof ICustomWirelessTerminalItem && terminalA.func_77973_b() != terminalB.func_77973_b()) {
            ItemStack wut = new ItemStack((Item)LibItems.ULTIMATE_TERMINAL);
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagList terminalList = new NBTTagList();
            String encKey = "";
            IAEItemPowerStorage powerItem = (IAEItemPowerStorage)wut.func_77973_b();
            double maxPower = powerItem.getAEMaxPower(wut);
            double totalPower = powerItem.getAECurrentPower(terminalA);
            int infinityEnergy = WTApi.instance().getInfinityEnergy(terminalA);
            infinityEnergy = (infinityEnergy += WTApi.instance().getInfinityEnergy(terminalB)) > Integer.MAX_VALUE ? Integer.MAX_VALUE : infinityEnergy;
            WTApi.instance().setInfinityEnergy(terminalA, 0);
            WTApi.instance().setInfinityEnergy(terminalB, 0);
            double newPower = totalPower > maxPower ? maxPower : (totalPower += powerItem.getAECurrentPower(terminalB));
            ItemStack emptyTermA = terminalA.func_77946_l();
            ItemStack emptyTermB = terminalB.func_77946_l();
            emptyTermA.func_77982_d(null);
            emptyTermB.func_77982_d(null);
            terminalList.func_74742_a((NBTBase)emptyTermA.func_77955_b(new NBTTagCompound()));
            encKey = ((ItemWT)terminalA.func_77973_b()).getEncryptionKey(terminalA);
            terminalList.func_74742_a((NBTBase)emptyTermB.func_77955_b(new NBTTagCompound()));
            if (encKey.isEmpty()) {
                encKey = ((ItemWT)terminalB.func_77973_b()).getEncryptionKey(terminalB);
            }
            nbt.func_179237_a(terminalA.func_77978_p());
            nbt.func_179237_a(terminalB.func_77978_p());
            nbt.func_74782_a(STOREDTERMINALS_KEY, (NBTBase)terminalList);
            nbt.func_74768_a(SELECTEDTERMINAL_KEY, 0);
            nbt.func_74780_a("internalCurrentPower", newPower);
            wut.func_77982_d(nbt);
            WTApi.instance().setInfinityEnergy(wut, infinityEnergy);
            if (!encKey.isEmpty()) {
                ((ItemWT)wut.func_77973_b()).setEncryptionKey(wut, encKey, "");
            }
            return wut;
        }
        return ItemStack.field_190927_a;
    }

    public static ResourceLocation[] getMenuIcons(ItemStack wut) {
        List<Pair<ItemStack, Integer>> stacks = ItemWUT.getStoredTerminalStacks(wut);
        ResourceLocation[] icons = new ResourceLocation[stacks.size()];
        for (int i = 0; i < stacks.size(); ++i) {
            icons[i] = ((ICustomWirelessTerminalItem)((ItemStack)stacks.get(i).getLeft()).func_77973_b()).getMenuIcon();
        }
        return icons;
    }

    @Override
    public ResourceLocation getMenuIcon() {
        return new ResourceLocation("ae2wtlib", "textures/items/wut");
    }

    @Override
    public int getColor() {
        return -11626222;
    }
}

