/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesRack;
import com.minecolonies.api.blocks.types.RackType;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class TileEntityRack
extends AbstractTileEntityRack {
    private final Map<ItemStorage, Integer> content = new HashMap<ItemStorage, Integer>();
    private int size = 0;
    private CombinedInvWrapper combinedHandler;

    @Override
    public boolean hasItemStack(ItemStack stack) {
        return this.content.containsKey(new ItemStorage(stack));
    }

    @Override
    public void setInWarehouse(Boolean isInWarehouse) {
        this.inWarehouse = isInWarehouse;
    }

    @Override
    public boolean freeStacks() {
        return this.content.isEmpty();
    }

    @Override
    public int getFreeSlots() {
        int freeSlots = this.inventory.getSlots();
        for (Map.Entry<ItemStorage, Integer> entry : this.content.entrySet()) {
            double slotsNeeded = (double)entry.getValue().intValue() / (double)entry.getKey().getItemStack().func_77976_d();
            freeSlots -= (int)Math.ceil(slotsNeeded);
        }
        return freeSlots;
    }

    @Override
    public boolean hasItemStack(ItemStack stack, boolean ignoreDamageValue) {
        ItemStorage compareStorage = new ItemStorage(stack, ignoreDamageValue);
        for (Map.Entry<ItemStorage, Integer> entry : this.content.entrySet()) {
            if (!compareStorage.equals(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasItemStack(@NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        for (Map.Entry<ItemStorage, Integer> entry : this.content.entrySet()) {
            if (!itemStackSelectionPredicate.test(entry.getKey().getItemStack())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void upgradeItemStorage() {
        ++this.size;
        AbstractTileEntityRack.RackInventory tempInventory = new AbstractTileEntityRack.RackInventory(27 + this.size * 9);
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            tempInventory.setStackInSlot(slot, this.inventory.getStackInSlot(slot));
        }
        this.inventory = tempInventory;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        if (this.main && this.combinedHandler == null && this.getOtherChest() != null) {
            this.combinedHandler = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.getOtherChest().getInventory()});
        }
    }

    @Override
    public int getItemCount(Predicate<ItemStack> predicate) {
        for (Map.Entry<ItemStorage, Integer> entry : this.content.entrySet()) {
            if (!predicate.test(entry.getKey().getItemStack())) continue;
            return entry.getValue();
        }
        return 0;
    }

    @Override
    public void updateItemStorage() {
        this.content.clear();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
            ItemStorage storage = new ItemStorage(stack.func_77946_l());
            int amount = ItemStackUtils.getSize(stack);
            if (this.content.containsKey(storage)) {
                amount += this.content.remove(storage).intValue();
            }
            this.content.put(storage, amount);
        }
        this.updateBlockState();
        this.func_70296_d();
    }

    @Override
    protected void updateBlockState() {
        if (this.field_145850_b != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof AbstractBlockMinecoloniesRack && (this.main || this.single)) {
            IBlockState typeNeighbor;
            IBlockState typeHere;
            if (this.content.isEmpty() && (this.getOtherChest() == null || this.getOtherChest().isEmpty())) {
                if (this.getOtherChest() != null && this.field_145850_b.func_180495_p(this.field_174879_c.func_177973_b((Vec3i)this.relativeNeighbor)).func_177230_c() instanceof AbstractBlockMinecoloniesRack) {
                    typeHere = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.EMPTYAIR));
                    typeNeighbor = this.field_145850_b.func_180495_p(this.field_174879_c.func_177973_b((Vec3i)this.relativeNeighbor)).func_177226_a(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.DEFAULTDOUBLE)).func_177226_a((IProperty)AbstractBlockMinecoloniesRack.FACING, (Comparable)BlockPosUtil.getFacing(this.field_174879_c, this.field_174879_c.func_177973_b((Vec3i)this.relativeNeighbor)));
                } else {
                    typeHere = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.DEFAULT));
                    typeNeighbor = null;
                }
            } else if (this.getOtherChest() != null && this.field_145850_b.func_180495_p(this.field_174879_c.func_177973_b((Vec3i)this.relativeNeighbor)).func_177230_c() instanceof AbstractBlockMinecoloniesRack) {
                typeHere = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.EMPTYAIR));
                typeNeighbor = this.field_145850_b.func_180495_p(this.field_174879_c.func_177973_b((Vec3i)this.relativeNeighbor)).func_177226_a(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.FULLDOUBLE)).func_177226_a((IProperty)AbstractBlockMinecoloniesRack.FACING, (Comparable)BlockPosUtil.getFacing(this.field_174879_c, this.field_174879_c.func_177973_b((Vec3i)this.relativeNeighbor)));
            } else {
                typeHere = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a(AbstractBlockMinecoloniesRack.VARIANT, (Comparable)((Object)RackType.FULL));
                typeNeighbor = null;
            }
            if (this.isMain() && this.getOtherChest() != null && this.getOtherChest().isMain()) {
                this.getOtherChest().setMain(false);
            }
            this.field_145850_b.func_175656_a(this.field_174879_c, typeHere);
            if (typeNeighbor != null) {
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177973_b((Vec3i)this.relativeNeighbor), typeNeighbor);
            }
        }
    }

    @Override
    public AbstractTileEntityRack getOtherChest() {
        if (this.relativeNeighbor == null || this.field_145850_b == null) {
            return null;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177973_b((Vec3i)this.relativeNeighbor));
        if (tileEntity instanceof TileEntityRack) {
            if (!this.func_174877_v().equals((Object)((TileEntityRack)tileEntity).getNeighbor())) {
                ((AbstractTileEntityRack)tileEntity).setNeighbor(this.func_174877_v());
            }
            return (AbstractTileEntityRack)tileEntity;
        }
        this.single = true;
        this.relativeNeighbor = null;
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("tagSIze")) {
            this.size = compound.func_74762_e("tagSIze");
            if (this.size > 0) {
                this.inventory = new AbstractTileEntityRack.RackInventory(27 + this.size * 9);
            }
        }
        if (compound.func_74764_b("neighbor")) {
            BlockPos neighbor = BlockPosUtil.readFromNBT(compound, "neighbor");
            if (neighbor != BlockPos.field_177992_a) {
                this.relativeNeighbor = this.field_174879_c.func_177973_b((Vec3i)neighbor);
            }
        } else if (compound.func_74764_b("relNeighbor")) {
            this.relativeNeighbor = BlockPosUtil.readFromNBT(compound, "relNeighbor");
        }
        if (this.relativeNeighbor != null) {
            if (this.relativeNeighbor.func_177956_o() != 0) {
                this.relativeNeighbor = null;
            } else {
                this.single = false;
            }
        }
        NBTTagList inventoryTagList = compound.func_150295_c("inventory", 10);
        for (int i = 0; i < inventoryTagList.func_74745_c(); ++i) {
            NBTTagCompound inventoryCompound = inventoryTagList.func_150305_b(i);
            ItemStack stack = new ItemStack(inventoryCompound);
            if (ItemStackUtils.getSize(stack) <= 0) {
                this.inventory.setStackInSlot(i, ItemStackUtils.EMPTY);
                continue;
            }
            this.inventory.setStackInSlot(i, stack);
        }
        if (compound.func_74764_b("Items")) {
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.inventory.getSlots()) continue;
                this.inventory.setStackInSlot(j, new ItemStack(nbttagcompound));
            }
        }
        this.main = compound.func_74767_n("main");
        this.updateItemStorage();
        this.inWarehouse = compound.func_74767_n("inWarehouse");
    }

    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("tagSIze", this.size);
        if (this.relativeNeighbor != null) {
            BlockPosUtil.writeToNBT(compound, "relNeighbor", this.relativeNeighbor);
        }
        NBTTagList inventoryTagList = new NBTTagList();
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            NBTTagCompound inventoryCompound = new NBTTagCompound();
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack == ItemStackUtils.EMPTY) {
                new ItemStack(Blocks.field_150350_a, 0).func_77955_b(inventoryCompound);
            } else {
                stack.func_77955_b(inventoryCompound);
            }
            inventoryTagList.func_74742_a((NBTBase)inventoryCompound);
        }
        compound.func_74782_a("inventory", (NBTBase)inventoryTagList);
        compound.func_74757_a("main", this.main);
        compound.func_74757_a("inWarehouse", this.inWarehouse);
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(compound));
    }

    @NotNull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public boolean shouldRefresh(World world, BlockPos pos, @NotNull IBlockState oldState, @NotNull IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean hasCapability(@NotNull Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public void func_189667_a(Rotation rotationIn) {
        super.func_189667_a(rotationIn);
        if (this.relativeNeighbor != null) {
            this.relativeNeighbor = this.relativeNeighbor.func_190942_a(rotationIn);
        }
    }

    public <T> T getCapability(@NotNull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.single) {
                return (T)this.inventory;
            }
            if (this.getOtherChest() != null) {
                if (this.isMain()) {
                    if (this.combinedHandler == null) {
                        this.combinedHandler = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.getOtherChest().getInventory()});
                    }
                    return (T)this.combinedHandler;
                }
                if (this.getOtherChest().isMain()) {
                    return (T)this.getOtherChest().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                }
                this.main = true;
                if (this.combinedHandler == null) {
                    this.combinedHandler = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.getOtherChest().getInventory()});
                }
                this.func_70296_d();
                return (T)this.combinedHandler;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public BlockPos getNeighbor() {
        if (this.relativeNeighbor == null) {
            return null;
        }
        return this.field_174879_c.func_177973_b((Vec3i)this.relativeNeighbor);
    }

    @Override
    public boolean setNeighbor(BlockPos neighbor) {
        if (neighbor == null) {
            this.single = true;
            this.relativeNeighbor = null;
            this.func_70296_d();
        } else if (this.field_174879_c.func_177973_b((Vec3i)neighbor).func_177956_o() == 0) {
            this.relativeNeighbor = this.field_174879_c.func_177973_b((Vec3i)neighbor);
            this.single = false;
            this.func_70296_d();
            return true;
        }
        return false;
    }
}

