/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.HappinessData;
import com.minecolonies.api.colony.IChunkmanagerCapability;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Player;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.compatibility.CompatibilityManager;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.crafting.IRecipeManager;
import com.minecolonies.api.util.ChunkLoadStorage;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.ColonyManagerConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyList;
import com.minecolonies.coremod.colony.ColonyManagerWorldAccess;
import com.minecolonies.coremod.colony.ColonyView;
import com.minecolonies.coremod.colony.IColonyManagerCapability;
import com.minecolonies.coremod.colony.requestsystem.management.manager.StandardRecipeManager;
import com.minecolonies.coremod.util.BackUpHelper;
import com.minecolonies.coremod.util.ChunkDataHelper;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColonyManager
implements IColonyManager {
    @NotNull
    private final Map<Integer, ColonyList<IColonyView>> colonyViews = new HashMap<Integer, ColonyList<IColonyView>>();
    private final IRecipeManager recipeManager = new StandardRecipeManager();
    private final ICompatibilityManager compatibilityManager = new CompatibilityManager();
    private UUID serverUUID = null;
    private boolean schematicDownloaded = false;
    private boolean loaded = false;

    @Override
    public void createColony(@NotNull World w, BlockPos pos, @NotNull EntityPlayer player, @NotNull String style) {
        IColonyManagerCapability cap = (IColonyManagerCapability)w.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return;
        }
        IColony colony = cap.createColony(w, pos);
        colony.setStyle(style);
        String colonyName = LanguageHandler.format("com.minecolonies.coremod.gui.townHall.defaultName", player.getDisplayNameString());
        colony.setName(colonyName);
        colony.getPermissions().setPlayerRank(player.func_146103_bH().getId(), Rank.OWNER, w);
        colony.getPackageManager().addImportantColonyPlayer((EntityPlayerMP)player);
        colony.getPackageManager().addCloseSubscriber((EntityPlayerMP)player);
        colony.getStatsManager().triggerAchievement(ModAchievements.achievementGetSupply);
        colony.getStatsManager().triggerAchievement(ModAchievements.achievementTownhall);
        Log.getLogger().info(String.format("New Colony Id: %d by %s", colony.getID(), player.func_70005_c_()));
        if (colony.getWorld() == null) {
            Log.getLogger().error("Unable to claim chunks because of the missing world in the colony, please report this to the mod authors!");
            return;
        }
        if (Configurations.gameplay.enableDynamicColonySizes) {
            ChunkDataHelper.claimColonyChunks(colony.getWorld(), true, colony.getID(), colony.getCenter(), colony.getDimension(), 2);
        } else {
            ChunkDataHelper.claimColonyChunks(colony.getWorld(), true, colony.getID(), colony.getCenter(), colony.getDimension());
        }
    }

    @Override
    public void deleteColonyByWorld(int id, boolean canDestroy, World world) {
        this.deleteColony(this.getColonyByWorld(id, world), canDestroy);
    }

    @Override
    public void deleteColonyByDimension(int id, boolean canDestroy, int dimension) {
        this.deleteColony(this.getColonyByDimension(id, dimension), canDestroy);
    }

    private void deleteColony(@Nullable IColony iColony, boolean canDestroy) {
        if (!(iColony instanceof Colony)) {
            return;
        }
        Colony colony = (Colony)iColony;
        if (colony == null) {
            Log.getLogger().warn("Deleting Colony errored, colony null");
            return;
        }
        int id = colony.getID();
        World world = colony.getWorld();
        try {
            if (!Configurations.gameplay.enableDynamicColonySizes) {
                ChunkDataHelper.claimColonyChunks(world, false, id, colony.getCenter(), colony.getDimension());
            }
            Log.getLogger().info("Removing citizens for " + id);
            for (ICitizenData citizenData : new ArrayList<ICitizenData>(colony.getCitizenManager().getCitizens())) {
                Log.getLogger().info("Kill Citizen " + citizenData.getName());
                citizenData.getCitizenEntity().ifPresent(entityCitizen -> entityCitizen.func_70645_a(ColonyManagerConstants.CONSOLE_DAMAGE_SOURCE));
            }
            Log.getLogger().info("Removing buildings for " + id);
            for (IBuilding building : new ArrayList<IBuilding>(colony.getBuildingManager().getBuildings().values())) {
                BlockPos location = building.getPosition();
                Log.getLogger().info("Delete Building at " + location);
                if (canDestroy) {
                    building.deconstruct();
                }
                building.destroy();
                if (!(world.func_180495_p(location).func_177230_c() instanceof AbstractBlockHut)) continue;
                Log.getLogger().info("Found Block, deleting " + world.func_180495_p(location).func_177230_c());
                world.func_175698_g(location);
            }
            try {
                MinecraftForge.EVENT_BUS.unregister((Object)colony.getEventHandler());
            }
            catch (NullPointerException e) {
                Log.getLogger().warn("Can't unregister the event handler twice");
            }
            Log.getLogger().info("Deleting colony: " + colony.getID());
            IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
            if (cap == null) {
                Log.getLogger().warn("Missing world capability with colony manager!");
                return;
            }
            BackUpHelper.markColonyDeleted(colony.getID(), colony.getDimension());
            cap.deleteColony(id);
            Log.getLogger().info("Done with " + id);
        }
        catch (RuntimeException e) {
            Log.getLogger().warn("Deleting Colony " + id + " errored:", (Throwable)e);
        }
    }

    @Override
    @Nullable
    public IColony getColonyByWorld(int id, World world) {
        IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return null;
        }
        return cap.getColony(id);
    }

    @Override
    @Nullable
    public IColony getColonyByDimension(int id, int dimension) {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimension);
        IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return null;
        }
        return cap.getColony(id);
    }

    @Override
    public IBuilding getBuilding(@NotNull World w, @NotNull BlockPos pos) {
        IBuilding building;
        IColony colony = this.getColonyByPosFromWorld(w, pos);
        if (colony != null && (building = colony.getBuildingManager().getBuilding(pos)) != null) {
            return building;
        }
        Log.getLogger().warn("Colony at place " + pos + " is null! " + w.field_73011_w.getDimension());
        for (IColony otherColony : this.getColonies(w)) {
            IBuilding building2 = otherColony.getBuildingManager().getBuilding(pos);
            if (building2 == null) continue;
            return building2;
        }
        return null;
    }

    @Override
    public IColony getColonyByPosFromWorld(@NotNull World w, @NotNull BlockPos pos) {
        Chunk centralChunk = w.func_175726_f(pos);
        int id = ((IColonyTagCapability)centralChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null)).getOwningColony();
        if (id == 0) {
            return null;
        }
        return this.getColonyByWorld(id, w);
    }

    @Override
    public IColony getColonyByPosFromDim(int dim, @NotNull BlockPos pos) {
        WorldServer w = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dim);
        return this.getColonyByPosFromWorld((World)w, pos);
    }

    @Override
    public boolean isTooCloseToColony(@NotNull World w, @NotNull BlockPos pos) {
        if (Configurations.gameplay.enableDynamicColonySizes) {
            return !ChunkDataHelper.canClaimChunksInRange(w, pos, Configurations.gameplay.minTownHallPadding);
        }
        IChunkmanagerCapability worldCapability = (IChunkmanagerCapability)w.getCapability(MineColonies.CHUNK_STORAGE_UPDATE_CAP, null);
        if (worldCapability == null) {
            return true;
        }
        Chunk centralChunk = w.func_175726_f(pos);
        IColonyTagCapability colonyCap = (IColonyTagCapability)centralChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        if (colonyCap == null) {
            return true;
        }
        ChunkLoadStorage storage = worldCapability.getChunkStorage(centralChunk.field_76635_g, centralChunk.field_76647_h);
        if (storage != null) {
            storage.applyToCap(colonyCap, centralChunk);
        }
        return !colonyCap.getAllCloseColonies().isEmpty();
    }

    @Override
    @NotNull
    public List<IColony> getColonies(@NotNull World w) {
        IColonyManagerCapability cap = (IColonyManagerCapability)w.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return Collections.emptyList();
        }
        return cap.getColonies();
    }

    @Override
    @NotNull
    public List<IColony> getAllColonies() {
        ArrayList<IColony> allColonies = new ArrayList<IColony>();
        for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
            if (cap == null) continue;
            allColonies.addAll(cap.getColonies());
        }
        return allColonies;
    }

    @Override
    @NotNull
    public List<IColony> getColoniesAbandonedSince(int abandonedSince) {
        ArrayList<IColony> sortedList = new ArrayList<IColony>();
        for (IColony colony : this.getAllColonies()) {
            if (colony.getLastContactInHours() < abandonedSince) continue;
            sortedList.add(colony);
        }
        return sortedList;
    }

    @Override
    public IBuildingView getBuildingView(int dimension, BlockPos pos) {
        if (this.colonyViews.containsKey(dimension)) {
            for (IColonyView colony : this.colonyViews.get(dimension)) {
                IBuildingView building = colony.getBuilding(pos);
                if (building == null) continue;
                return building;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IColony getIColony(@NotNull World w, @NotNull BlockPos pos) {
        return w.field_72995_K ? this.getColonyView(w, pos) : this.getColonyByPosFromWorld(w, pos);
    }

    private IColonyView getColonyView(@NotNull World w, @NotNull BlockPos pos) {
        Chunk centralChunk = w.func_175726_f(pos);
        int id = ((IColonyTagCapability)centralChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null)).getOwningColony();
        if (id == 0) {
            return null;
        }
        return this.getColonyView(id, w.field_73011_w.getDimension());
    }

    @Override
    @Nullable
    public IColony getClosestIColony(@NotNull World w, @NotNull BlockPos pos) {
        return w.field_72995_K ? this.getClosestColonyView(w, pos) : this.getClosestColony(w, pos);
    }

    @Override
    @Nullable
    public IColonyView getClosestColonyView(@Nullable World w, @Nullable BlockPos pos) {
        if (w == null || pos == null) {
            return null;
        }
        Chunk chunk = w.func_175726_f(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        if (cap.getOwningColony() != 0) {
            return this.getColonyView(cap.getOwningColony(), w.field_73011_w.getDimension());
        }
        if (!cap.getAllCloseColonies().isEmpty()) {
            IColonyView closestColony = null;
            long closestDist = Long.MAX_VALUE;
            for (int cId : cap.getAllCloseColonies()) {
                long dist;
                IColonyView c = this.getColonyView(cId, w.field_73011_w.getDimension());
                if (c == null || c.getDimension() != w.field_73011_w.getDimension() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
                closestColony = c;
                closestDist = dist;
            }
            return closestColony;
        }
        IColonyView closestColony = null;
        long closestDist = Long.MAX_VALUE;
        if (this.colonyViews.containsKey(w.field_73011_w.getDimension())) {
            for (IColonyView c : this.colonyViews.get(w.field_73011_w.getDimension())) {
                long dist;
                if (c.getDimension() != w.field_73011_w.getDimension() || c.getCenter() == null || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
                closestColony = c;
                closestDist = dist;
            }
        }
        return closestColony;
    }

    @Override
    public IColony getClosestColony(@NotNull World w, @NotNull BlockPos pos) {
        Chunk chunk = w.func_175726_f(pos);
        IColonyTagCapability cap = (IColonyTagCapability)chunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null);
        if (cap.getOwningColony() != 0) {
            return this.getColonyByWorld(cap.getOwningColony(), w);
        }
        if (!cap.getAllCloseColonies().isEmpty()) {
            IColony closestColony = null;
            long closestDist = Long.MAX_VALUE;
            for (int cId : cap.getAllCloseColonies()) {
                long dist;
                IColony c = this.getColonyByWorld(cId, w);
                if (c == null || c.getDimension() != w.field_73011_w.getDimension() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
                closestColony = c;
                closestDist = dist;
            }
            return closestColony;
        }
        IColony closestColony = null;
        long closestDist = Long.MAX_VALUE;
        for (IColony c : this.getColonies(w)) {
            long dist;
            if (c.getDimension() != w.field_73011_w.getDimension() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
            closestColony = c;
            closestDist = dist;
        }
        return closestColony;
    }

    @Override
    @Nullable
    public IColony getIColonyByOwner(@NotNull World w, @NotNull EntityPlayer owner) {
        return this.getIColonyByOwner(w, w.field_72995_K ? owner.func_110124_au() : owner.func_146103_bH().getId());
    }

    @Override
    @Nullable
    public IColony getIColonyByOwner(@NotNull World w, UUID owner) {
        return w.field_72995_K ? this.getColonyViewByOwner(owner, w.field_73011_w.getDimension()) : this.getColonyByOwner(owner);
    }

    private IColony getColonyViewByOwner(UUID owner, int dimension) {
        if (this.colonyViews.containsKey(dimension)) {
            for (IColonyView c : this.colonyViews.get(dimension)) {
                Player p = c.getPlayers().get(owner);
                if (p == null || !p.getRank().equals((Object)Rank.OWNER)) continue;
                return c;
            }
        }
        return null;
    }

    @Nullable
    private IColony getColonyByOwner(@Nullable UUID owner) {
        if (owner == null) {
            return null;
        }
        return this.getAllColonies().stream().filter(c -> owner.equals(c.getPermissions().getOwner())).findFirst().orElse(null);
    }

    @Override
    public int getMinimumDistanceBetweenTownHalls() {
        return 2 * Configurations.gameplay.workingRangeTownHallChunks * 16 + Configurations.gameplay.townHallPaddingChunk * 16;
    }

    @Override
    public void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (IColony c : this.getAllColonies()) {
                c.onServerTick(event);
            }
        }
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound compound) {
        if (this.serverUUID != null) {
            compound.func_186854_a("uuid", this.serverUUID);
        }
        NBTTagCompound compCompound = new NBTTagCompound();
        this.compatibilityManager.writeToNBT(compCompound);
        compound.func_74782_a("compatabilityManager", (NBTBase)compCompound);
        compound.func_74757_a("dist", true);
        NBTTagCompound recipeCompound = new NBTTagCompound();
        this.recipeManager.writeToNBT(recipeCompound);
        compound.func_74782_a("recipeManager", (NBTBase)recipeCompound);
        compound.func_74757_a("allchunk", true);
        compound.func_74757_a("amountOfColonies", true);
        compound.func_74757_a("colonycap", true);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound compound, @NotNull World world) {
        if (!compound.func_74764_b("dist")) {
            Configurations.gameplay.workingRangeTownHallChunks = (int)(Math.cos(0.7853981633974483) * (double)Configurations.gameplay.workingRangeTownHall / 16.0);
        }
        if (!compound.func_74764_b("colonycap")) {
            if (!compound.func_74764_b("amountOfColonies")) {
                NBTTagList colonyTags = compound.func_150295_c("colonies", 10);
                for (int i = 0; i < colonyTags.func_74745_c(); ++i) {
                    NBTTagCompound colonyCompound = colonyTags.func_150305_b(i);
                    WorldServer colonyWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(colonyCompound.func_74762_e("dimension"));
                    IColonyManagerCapability cap = (IColonyManagerCapability)colonyWorld.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
                    Colony colony = Colony.loadColony(colonyTags.func_150305_b(i), (World)FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(colonyCompound.func_74762_e("dimension")));
                    cap.addColony(colony);
                }
                IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
                Log.getLogger().info(String.format("Loaded %d colonies", cap.getColonies().size()));
            } else {
                int size = compound.func_74762_e("amountOfColonies");
                File saveDir = new File(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b(), "minecolonies");
                for (int colonyId = 0; colonyId <= size; ++colonyId) {
                    NBTTagCompound colonyData = BackUpHelper.loadNBTFromPath(new File(saveDir, String.format("colony%d.dat", colonyId)));
                    if (colonyData == null) continue;
                    WorldServer colonyWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(colonyData.func_74762_e("dimension"));
                    IColonyManagerCapability cap = (IColonyManagerCapability)colonyWorld.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
                    Colony colony = Colony.loadColony(colonyData, (World)colonyWorld);
                    colony.getCitizenManager().checkCitizensForHappiness();
                    cap.addColony(colony);
                }
            }
        }
        if (compound.func_186855_b("uuid")) {
            this.serverUUID = compound.func_186857_a("uuid");
        }
        if (compound.func_74764_b("compatabilityManager")) {
            this.compatibilityManager.readFromNBT(compound.func_74775_l("compatabilityManager"));
        }
        NBTTagCompound recipeCompound = compound.func_74775_l("recipeManager");
        this.recipeManager.readFromNBT(recipeCompound);
        if (!compound.func_74764_b("allchunk")) {
            ChunkDataHelper.loadChunkStorageToWorldCapability(world);
        }
    }

    @Override
    public void onClientTick(@NotNull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e == null && !this.colonyViews.isEmpty()) {
            this.colonyViews.clear();
        }
        if (!this.compatibilityManager.isDiscoveredAlready()) {
            this.compatibilityManager.discover();
        }
    }

    @Override
    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.getColonies(event.world).forEach(c -> c.onWorldTick(event));
        }
        if (!this.compatibilityManager.isDiscoveredAlready()) {
            this.compatibilityManager.discover();
        }
    }

    @Override
    public void onWorldLoad(@NotNull World world) {
        if (!world.field_72995_K) {
            if (!this.loaded) {
                File file = BackUpHelper.getSaveLocation();
                NBTTagCompound data = BackUpHelper.loadNBTFromPath(file);
                if (data != null) {
                    this.readFromNBT(data, world);
                }
                if (this.serverUUID == null) {
                    this.serverUUID = UUID.randomUUID();
                    Log.getLogger().info(String.format("New Server UUID %s", this.serverUUID));
                } else {
                    Log.getLogger().info(String.format("Server UUID %s", this.serverUUID));
                }
                this.loaded = true;
                BackUpHelper.loadMissingColonies();
            }
            for (IColony c : this.getColonies(world)) {
                c.onWorldLoad(world);
            }
            world.func_72954_a((IWorldEventListener)new ColonyManagerWorldAccess());
        }
    }

    @Override
    public UUID getServerUUID() {
        return this.serverUUID;
    }

    @Override
    public void setServerUUID(UUID uuid) {
        this.serverUUID = uuid;
    }

    @Override
    public void onWorldUnload(@NotNull World world) {
        if (!world.field_72995_K && !(world instanceof WorldServerMulti)) {
            for (IColony c : this.getColonies(world)) {
                c.onWorldUnload(world);
            }
            if (this.loaded) {
                BackUpHelper.backupColonyData();
                this.loaded = false;
            }
        }
    }

    @Override
    public void handleColonyViewMessage(int colonyId, @NotNull ByteBuf colonyData, @NotNull World world, boolean isNewSubscription, int dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view == null) {
            view = ColonyView.createFromNetwork(colonyId);
            if (this.colonyViews.containsKey(dim)) {
                this.colonyViews.get(dim).add(view);
            } else {
                ColonyList<IColonyView> list = new ColonyList<IColonyView>();
                list.add(view);
                this.colonyViews.put(dim, list);
            }
        }
        view.handleColonyViewMessage(colonyData, world, isNewSubscription);
    }

    @Override
    public IColonyView getColonyView(int id, int dimension) {
        if (this.colonyViews.containsKey(dimension)) {
            return this.colonyViews.get(dimension).get(id);
        }
        return null;
    }

    @Override
    public void handlePermissionsViewMessage(int colonyID, @NotNull ByteBuf data, int dim) {
        IColonyView view = this.getColonyView(colonyID, dim);
        if (view == null) {
            Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyID));
        } else {
            view.handlePermissionsViewMessage(data);
        }
    }

    @Override
    public void handleColonyViewCitizensMessage(int colonyId, int citizenId, ByteBuf buf, int dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view == null) {
            return;
        }
        view.handleColonyViewCitizensMessage(citizenId, buf);
    }

    @Override
    public void handleColonyViewWorkOrderMessage(int colonyId, ByteBuf buf, int dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view == null) {
            return;
        }
        view.handleColonyViewWorkOrderMessage(buf);
    }

    @Override
    public void handleColonyViewRemoveCitizenMessage(int colonyId, int citizenId, int dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyViewRemoveCitizenMessage(citizenId);
        }
    }

    @Override
    public void handleColonyBuildingViewMessage(int colonyId, BlockPos buildingId, @NotNull ByteBuf buf, int dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyBuildingViewMessage(buildingId, buf);
        } else {
            Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyId));
        }
    }

    @Override
    public void handleColonyViewRemoveBuildingMessage(int colonyId, BlockPos buildingId, int dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyViewRemoveBuildingMessage(buildingId);
        }
    }

    @Override
    public void handleColonyViewRemoveWorkOrderMessage(int colonyId, int workOrderId, int dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyViewRemoveWorkOrderMessage(workOrderId);
        }
    }

    @Override
    public void handleHappinessDataMessage(int colonyId, HappinessData data, int dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleHappinessDataMessage(data);
        }
    }

    @Override
    public boolean isSchematicDownloaded() {
        return this.schematicDownloaded;
    }

    @Override
    public void setSchematicDownloaded(boolean downloaded) {
        this.schematicDownloaded = downloaded;
    }

    @Override
    public boolean isCoordinateInAnyColony(@NotNull World world, BlockPos pos) {
        Chunk centralChunk = world.func_175726_f(pos);
        return ((IColonyTagCapability)centralChunk.getCapability(MineColonies.CLOSE_COLONY_CAP, null)).getOwningColony() != 0;
    }

    @Override
    public ICompatibilityManager getCompatibilityManager() {
        return this.compatibilityManager;
    }

    @Override
    public IRecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    @Override
    public int getTopColonyId() {
        int top = 0;
        for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            int tempTop;
            IColonyManagerCapability cap = (IColonyManagerCapability)world.getCapability(MineColonies.COLONY_MANAGER_CAP, null);
            if (cap == null || (tempTop = cap.getTopID()) <= top) continue;
            top = tempTop;
        }
        return top;
    }

    @Override
    public void resetColonyViews() {
        this.colonyViews.clear();
    }
}

