/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHall;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.colony.permissions.PermissionEvent;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowTownHall;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingTownHall
extends AbstractBuilding
implements ITownHall {
    private static final String TOWN_HALL = "TownHall";
    private static final int MAX_BUILDING_LEVEL = 5;
    private final LinkedList<PermissionEvent> permissionEvents = new LinkedList();

    public BuildingTownHall(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return TOWN_HALL;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementBuildingTownhall);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementUpgradeTownhallMax);
        }
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.townHall;
    }

    @Override
    public void addPermissionEvent(PermissionEvent event) {
        if (this.getBuildingLevel() >= 1 && !this.permissionEvents.contains(event)) {
            if (this.permissionEvents.size() >= 100) {
                this.permissionEvents.removeFirst();
            }
            this.permissionEvents.add(event);
            this.markDirty();
        }
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(Configurations.gameplay.canPlayerUseColonyTPCommand);
        buf.writeInt(this.permissionEvents.size());
        for (PermissionEvent event : this.permissionEvents) {
            event.serialize(buf);
        }
    }

    @Override
    public int getClaimRadius(int newLevel) {
        if (newLevel + 1 < Configurations.gameplay.minTownHallPadding) {
            return Configurations.gameplay.minTownHallPadding;
        }
        return newLevel + 1;
    }

    @Override
    public boolean canBeGathered() {
        return false;
    }

    public static class View
    extends AbstractBuildingView
    implements ITownHallView {
        private final List<PermissionEvent> permissionEvents = new LinkedList<PermissionEvent>();
        private boolean canPlayerUseTP = false;

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowTownHall(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.canPlayerUseTP = buf.readBoolean();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.permissionEvents.add(new PermissionEvent(buf));
            }
        }

        @Override
        public List<PermissionEvent> getPermissionEvents() {
            return new LinkedList<PermissionEvent>(this.permissionEvents);
        }

        @Override
        public boolean canPlayerUseTP() {
            return this.canPlayerUseTP;
        }
    }
}

