/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.client.render.modeltype.BipedModelType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemDeliveryManJobDataStore;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Delivery;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.sounds.DeliverymanSounds;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.ai.citizen.deliveryman.EntityAIWorkDeliveryman;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JobDeliveryman
extends AbstractJob {
    private IToken<?> rsDataStoreToken;
    public static final double BONUS_SPEED_PER_LEVEL = 0.003;
    private boolean active = false;

    public JobDeliveryman(ICitizenData entity) {
        super(entity);
        this.setupRsDataStore();
    }

    private void setupRsDataStore() {
        this.rsDataStoreToken = this.getCitizen().getColony().getRequestManager().getDataStoreManager().get(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), TypeConstants.REQUEST_SYSTEM_DELIVERY_MAN_JOB_DATA_STORE).getId();
    }

    @Override
    public void onLevelUp(int newLevel) {
        if (this.getCitizen().getCitizenEntity().isPresent()) {
            AbstractEntityCitizen worker = this.getCitizen().getCitizenEntity().get();
            worker.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3 + (double)(newLevel > 50 ? 50 : newLevel) * 0.003);
        }
    }

    @Override
    public JobEntry getJobRegistryEntry() {
        return ModJobs.delivery;
    }

    @Override
    @NotNull
    public String getName() {
        return "com.minecolonies.coremod.job.Deliveryman";
    }

    @Override
    @NotNull
    public BipedModelType getModel() {
        return BipedModelType.DELIVERYMAN;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74782_a("DataStoreToken", (NBTBase)StandardFactoryController.getInstance().serialize(this.rsDataStoreToken));
        compound.func_74757_a("activeNodeNode", this.active);
        return compound;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        if (compound.func_74764_b("DataStoreToken")) {
            this.rsDataStoreToken = (IToken)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("DataStoreToken"));
        } else {
            this.setupRsDataStore();
        }
        this.active = compound.func_74767_n("activeNodeNode");
    }

    @Override
    @NotNull
    public AbstractAISkeleton<JobDeliveryman> generateAI() {
        return new EntityAIWorkDeliveryman(this);
    }

    @Override
    public SoundEvent getBedTimeSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? DeliverymanSounds.Female.offToBed : null;
        }
        return null;
    }

    @Override
    @Nullable
    public SoundEvent getBadWeatherSound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? DeliverymanSounds.Female.badWeather : null;
        }
        return null;
    }

    @Override
    @Nullable
    public SoundEvent getMoveAwaySound() {
        if (this.getCitizen() != null) {
            return this.getCitizen().isFemale() ? DeliverymanSounds.Female.hostile : null;
        }
        return null;
    }

    private IRequestSystemDeliveryManJobDataStore getDataStore() {
        return this.getCitizen().getColony().getRequestManager().getDataStoreManager().get(this.rsDataStoreToken, TypeConstants.REQUEST_SYSTEM_DELIVERY_MAN_JOB_DATA_STORE);
    }

    private LinkedList<IToken<?>> getTaskQueueFromDataStore() {
        return this.getDataStore().getQueue();
    }

    public boolean hasTask() {
        return !this.getTaskQueueFromDataStore().isEmpty() || this.getDataStore().isReturning();
    }

    public IRequest<Delivery> getCurrentTask() {
        if (this.getTaskQueueFromDataStore().isEmpty()) {
            return null;
        }
        return this.getColony().getRequestManager().getRequestForToken(this.getTaskQueueFromDataStore().peekFirst());
    }

    public void addRequest(@NotNull IToken<?> token) {
        this.getTaskQueueFromDataStore().add(token);
    }

    public void finishRequest(@NotNull boolean successful) {
        if (this.getTaskQueueFromDataStore().isEmpty()) {
            return;
        }
        this.setReturning(true);
        IToken<?> current = this.getTaskQueueFromDataStore().getFirst();
        this.getColony().getRequestManager().updateRequestState(current, successful ? RequestState.RESOLVED : RequestState.CANCELLED);
        if (!this.getTaskQueueFromDataStore().isEmpty() && current == this.getTaskQueueFromDataStore().getFirst()) {
            this.getTaskQueueFromDataStore().removeFirst();
        }
    }

    public void onTaskDeletion(@NotNull IToken<?> token) {
        if (this.getTaskQueueFromDataStore().contains(token)) {
            if (this.getTaskQueueFromDataStore().peek().equals(token)) {
                this.setReturning(true);
            }
            this.getTaskQueueFromDataStore().remove(token);
        }
    }

    public List<IToken<?>> getTaskQueue() {
        return ImmutableList.copyOf(this.getTaskQueueFromDataStore());
    }

    public boolean isReturning() {
        return this.getDataStore().isReturning();
    }

    public void setReturning(boolean returning) {
        this.getDataStore().setReturning(returning);
    }

    public void setActive(boolean b) {
        if (!b && this.active) {
            for (IToken<?> t : this.getTaskQueue()) {
                this.getColony().getRequestManager().updateRequestState(t, RequestState.CANCELLED);
            }
        } else if (!this.active && b) {
            this.active = b;
            ImmutableList<IToken<?>> tokenList = this.getColony().getRequestManager().getPlayerResolver().getAllAssignedRequests();
            this.getColony().getRequestManager().onColonyUpdate(request -> tokenList.contains(request.getId()));
        }
        this.active = b;
    }

    public boolean isActive() {
        return this.active;
    }
}

