/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.colonycommands.requestsystem;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.commands.AbstractSingleCommand;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class RSResetCommand
extends AbstractSingleCommand
implements IActionCommand {
    public static final String DESC = "reset";
    private static final String SUCCESS_MESSAGE = "After 1.618 Seconds it reinstantiated completely new.";
    private static final String COLONY_NULL = "Couldn't find colony %d.";
    private static final String COLONY_NOT_FOUND = "Couldn't find colony.";
    private static final String NO_ARGUMENTS = "Please define a colony";

    public RSResetCommand() {
        super(new String[0]);
    }

    public RSResetCommand(String ... parents) {
        super(parents);
    }

    @Override
    @NotNull
    public String getCommandUsage(@NotNull ICommandSender sender) {
        return super.getCommandUsage(sender) + "<ColonyId> <(Optional)Player>";
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState) throws CommandException {
        IColony colony = actionMenuState.getColonyForArgument("colony");
        if (colony == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(COLONY_NOT_FOUND));
            return;
        }
        this.executeShared(server, sender, colony);
    }

    @Override
    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, String ... args) throws CommandException {
        IColony colony;
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString(NO_ARGUMENTS));
            return;
        }
        Entity senderEntity = sender.func_174793_f();
        int colonyId = RSResetCommand.getColonyIdFromArg(args, 0, -1);
        int dimensionId = RSResetCommand.getDimensionIdFromArg(args, 0, sender.func_130014_f_().field_73011_w.getDimension());
        if (colonyId == -1 && senderEntity instanceof EntityPlayer) {
            colony = IColonyManager.getInstance().getIColonyByOwner((World)server.func_71218_a(dimensionId), ((EntityPlayer)sender).func_110124_au());
            if (colony == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(COLONY_NULL));
                return;
            }
            colonyId = colony.getID();
        }
        if ((colony = IColonyManager.getInstance().getColonyByWorld(colonyId, (World)server.func_71218_a(dimensionId))) == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(String.format(COLONY_NULL, colonyId)));
            return;
        }
        this.executeShared(server, sender, colony);
    }

    private void executeShared(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull IColony colony) throws CommandException {
        EntityPlayer player;
        Entity senderEntity = sender.func_174793_f();
        if (senderEntity instanceof EntityPlayer && !this.canPlayerUseCommand(player = (EntityPlayer)sender, AbstractSingleCommand.Commands.RSRESET, colony.getID())) {
            sender.func_145747_a((ITextComponent)new TextComponentString("You are not allowed to do that!"));
            return;
        }
        colony.getRequestManager().reset();
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format(SUCCESS_MESSAGE, colony.getID())));
    }

    @Override
    @NotNull
    public List<String> getTabCompletionOptions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUsernameIndex(@NotNull String[] args, int index) {
        return false;
    }
}

