/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.coremod.colony.buildings.AbstractFilterableListBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemScepterLumberjack
extends AbstractItemMinecolonies {
    private static final String NBT_START_POS = "minecolonies:start_pos";
    private static final String NBT_END_POS = "minecolonies:end_pos";
    private boolean hasSetFirstPosition = false;

    public ItemScepterLumberjack() {
        super("scepterLumberjack");
        this.func_77656_e(2);
        this.field_77777_bU = 1;
    }

    @NotNull
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        ItemStack scepter = playerIn.func_184586_b(hand);
        if (!scepter.func_77942_o()) {
            scepter.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound compound = scepter.func_77978_p();
        if (!this.hasSetFirstPosition) {
            LanguageHandler.sendPlayerMessage(playerIn, "item.minecolonies.scepterLumberjack.usedStart", new Object[0]);
            this.setPosition(compound, NBT_START_POS, pos);
        } else {
            LanguageHandler.sendPlayerMessage(playerIn, "item.minecolonies.scepterLumberjack.usedEnd", new Object[0]);
            this.setPosition(compound, NBT_END_POS, pos);
            this.storeRestrictedArea(playerIn, hand, worldIn);
        }
        return EnumActionResult.SUCCESS;
    }

    private void storeRestrictedArea(EntityPlayer player, EnumHand hand, World worldIn) {
        ItemStack scepter = player.func_184586_b(hand);
        if (!scepter.func_77942_o()) {
            scepter.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound compound = scepter.func_77978_p();
        BlockPos startRestriction = BlockPosUtil.readFromNBT(compound, NBT_START_POS);
        BlockPos endRestriction = BlockPosUtil.readFromNBT(compound, NBT_END_POS);
        int minX = Math.min(startRestriction.func_177958_n(), endRestriction.func_177958_n());
        int minZ = Math.min(startRestriction.func_177952_p(), endRestriction.func_177952_p());
        int maxX = Math.max(startRestriction.func_177958_n(), endRestriction.func_177958_n());
        int maxZ = Math.max(startRestriction.func_177952_p(), endRestriction.func_177952_p());
        int distX = maxX - minX;
        int distZ = maxZ - minZ;
        int area = distX * distZ;
        int radius = 50;
        double maxArea = 3.14 * Math.pow(50.0, 2.0);
        if ((double)area > maxArea) {
            LanguageHandler.sendPlayerMessage(player, "item.minecolonies.scepterLumberjack.restrictionTooBig", area, maxArea);
            return;
        }
        LanguageHandler.sendPlayerMessage(player, "item.minecolonies.scepterLumberjack.restrictionSet", area, maxArea);
        IColony colony = IColonyManager.getInstance().getColonyByWorld(compound.func_74762_e("id"), worldIn);
        BlockPos hutPos = BlockPosUtil.readFromNBT(compound, "pos");
        IBuilding hut = colony.getBuildingManager().getBuilding(hutPos);
        AbstractFilterableListBuilding abstractBuilding = (AbstractFilterableListBuilding)hut;
        BuildingLumberjack lumberjackBuilding = (BuildingLumberjack)abstractBuilding;
        lumberjackBuilding.setRestrictedArea(startRestriction, endRestriction);
        player.field_71071_by.func_70304_b(player.field_71071_by.field_70461_c);
    }

    private void setPosition(NBTTagCompound compound, String NBT2, BlockPos pos) {
        this.hasSetFirstPosition = !this.hasSetFirstPosition;
        BlockPosUtil.writeToNBT(compound, NBT2, pos);
    }
}

